/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datasync.model.TaskListEntry;

@SdkInternalApi
public class TaskListEntryMarshaller {
    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskArn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final TaskListEntryMarshaller instance = new TaskListEntryMarshaller();

    public static TaskListEntryMarshaller getInstance() {
        return instance;
    }

    public void marshall(TaskListEntry taskListEntry, ProtocolMarshaller protocolMarshaller) {
        if (taskListEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(taskListEntry.getTaskArn(), TASKARN_BINDING);
            protocolMarshaller.marshall(taskListEntry.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(taskListEntry.getName(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

