/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datasync.model.Ec2Config;
import java.util.List;

@SdkInternalApi
public class Ec2ConfigMarshaller {
    private static final MarshallingInfo<String> SUBNETARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetArn").build();
    private static final MarshallingInfo<List> SECURITYGROUPARNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupArns").build();
    private static final Ec2ConfigMarshaller instance = new Ec2ConfigMarshaller();

    public static Ec2ConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(Ec2Config ec2Config, ProtocolMarshaller protocolMarshaller) {
        if (ec2Config == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(ec2Config.getSubnetArn(), SUBNETARN_BINDING);
            protocolMarshaller.marshall(ec2Config.getSecurityGroupArns(), SECURITYGROUPARNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

