/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.TagListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAgentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String activationKey;
    private String agentName;
    private List<TagListEntry> tags;
    private String vpcEndpointId;
    private List<String> subnetArns;
    private List<String> securityGroupArns;

    public void setActivationKey(String activationKey) {
        this.activationKey = activationKey;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public CreateAgentRequest withActivationKey(String activationKey) {
        this.setActivationKey(activationKey);
        return this;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public CreateAgentRequest withAgentName(String agentName) {
        this.setAgentName(agentName);
        return this;
    }

    public List<TagListEntry> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagListEntry> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagListEntry>(tags);
    }

    public CreateAgentRequest withTags(TagListEntry ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagListEntry>(tags.length));
        }
        for (TagListEntry ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateAgentRequest withTags(Collection<TagListEntry> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVpcEndpointId(String vpcEndpointId) {
        this.vpcEndpointId = vpcEndpointId;
    }

    public String getVpcEndpointId() {
        return this.vpcEndpointId;
    }

    public CreateAgentRequest withVpcEndpointId(String vpcEndpointId) {
        this.setVpcEndpointId(vpcEndpointId);
        return this;
    }

    public List<String> getSubnetArns() {
        return this.subnetArns;
    }

    public void setSubnetArns(Collection<String> subnetArns) {
        if (subnetArns == null) {
            this.subnetArns = null;
            return;
        }
        this.subnetArns = new ArrayList<String>(subnetArns);
    }

    public CreateAgentRequest withSubnetArns(String ... subnetArns) {
        if (this.subnetArns == null) {
            this.setSubnetArns(new ArrayList<String>(subnetArns.length));
        }
        for (String ele : subnetArns) {
            this.subnetArns.add(ele);
        }
        return this;
    }

    public CreateAgentRequest withSubnetArns(Collection<String> subnetArns) {
        this.setSubnetArns(subnetArns);
        return this;
    }

    public List<String> getSecurityGroupArns() {
        return this.securityGroupArns;
    }

    public void setSecurityGroupArns(Collection<String> securityGroupArns) {
        if (securityGroupArns == null) {
            this.securityGroupArns = null;
            return;
        }
        this.securityGroupArns = new ArrayList<String>(securityGroupArns);
    }

    public CreateAgentRequest withSecurityGroupArns(String ... securityGroupArns) {
        if (this.securityGroupArns == null) {
            this.setSecurityGroupArns(new ArrayList<String>(securityGroupArns.length));
        }
        for (String ele : securityGroupArns) {
            this.securityGroupArns.add(ele);
        }
        return this;
    }

    public CreateAgentRequest withSecurityGroupArns(Collection<String> securityGroupArns) {
        this.setSecurityGroupArns(securityGroupArns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActivationKey() != null) {
            sb.append("ActivationKey: ").append(this.getActivationKey()).append(",");
        }
        if (this.getAgentName() != null) {
            sb.append("AgentName: ").append(this.getAgentName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVpcEndpointId() != null) {
            sb.append("VpcEndpointId: ").append(this.getVpcEndpointId()).append(",");
        }
        if (this.getSubnetArns() != null) {
            sb.append("SubnetArns: ").append(this.getSubnetArns()).append(",");
        }
        if (this.getSecurityGroupArns() != null) {
            sb.append("SecurityGroupArns: ").append(this.getSecurityGroupArns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRequest)) {
            return false;
        }
        CreateAgentRequest other = (CreateAgentRequest)obj;
        if (other.getActivationKey() == null ^ this.getActivationKey() == null) {
            return false;
        }
        if (other.getActivationKey() != null && !other.getActivationKey().equals(this.getActivationKey())) {
            return false;
        }
        if (other.getAgentName() == null ^ this.getAgentName() == null) {
            return false;
        }
        if (other.getAgentName() != null && !other.getAgentName().equals(this.getAgentName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVpcEndpointId() == null ^ this.getVpcEndpointId() == null) {
            return false;
        }
        if (other.getVpcEndpointId() != null && !other.getVpcEndpointId().equals(this.getVpcEndpointId())) {
            return false;
        }
        if (other.getSubnetArns() == null ^ this.getSubnetArns() == null) {
            return false;
        }
        if (other.getSubnetArns() != null && !other.getSubnetArns().equals(this.getSubnetArns())) {
            return false;
        }
        if (other.getSecurityGroupArns() == null ^ this.getSecurityGroupArns() == null) {
            return false;
        }
        return other.getSecurityGroupArns() == null || other.getSecurityGroupArns().equals(this.getSecurityGroupArns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActivationKey() == null ? 0 : this.getActivationKey().hashCode());
        hashCode = 31 * hashCode + (this.getAgentName() == null ? 0 : this.getAgentName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpointId() == null ? 0 : this.getVpcEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetArns() == null ? 0 : this.getSubnetArns().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupArns() == null ? 0 : this.getSecurityGroupArns().hashCode());
        return hashCode;
    }

    @Override
    public CreateAgentRequest clone() {
        return (CreateAgentRequest)super.clone();
    }
}

