/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.S3SnapshotAsset;

@SdkInternalApi
public class S3SnapshotAssetMarshaller {
    private static final MarshallingInfo<Double> SIZE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").build();
    private static final S3SnapshotAssetMarshaller instance = new S3SnapshotAssetMarshaller();

    public static S3SnapshotAssetMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3SnapshotAsset s3SnapshotAsset, ProtocolMarshaller protocolMarshaller) {
        if (s3SnapshotAsset == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3SnapshotAsset.getSize(), SIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

