/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehendmedical;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.comprehendmedical.AWSComprehendMedicalAsync;
import com.amazonaws.services.comprehendmedical.AWSComprehendMedicalAsyncClientBuilder;
import com.amazonaws.services.comprehendmedical.AWSComprehendMedicalClient;
import com.amazonaws.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobRequest;
import com.amazonaws.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobResult;
import com.amazonaws.services.comprehendmedical.model.DescribePHIDetectionJobRequest;
import com.amazonaws.services.comprehendmedical.model.DescribePHIDetectionJobResult;
import com.amazonaws.services.comprehendmedical.model.DetectEntitiesRequest;
import com.amazonaws.services.comprehendmedical.model.DetectEntitiesResult;
import com.amazonaws.services.comprehendmedical.model.DetectEntitiesV2Request;
import com.amazonaws.services.comprehendmedical.model.DetectEntitiesV2Result;
import com.amazonaws.services.comprehendmedical.model.DetectPHIRequest;
import com.amazonaws.services.comprehendmedical.model.DetectPHIResult;
import com.amazonaws.services.comprehendmedical.model.ListEntitiesDetectionV2JobsRequest;
import com.amazonaws.services.comprehendmedical.model.ListEntitiesDetectionV2JobsResult;
import com.amazonaws.services.comprehendmedical.model.ListPHIDetectionJobsRequest;
import com.amazonaws.services.comprehendmedical.model.ListPHIDetectionJobsResult;
import com.amazonaws.services.comprehendmedical.model.StartEntitiesDetectionV2JobRequest;
import com.amazonaws.services.comprehendmedical.model.StartEntitiesDetectionV2JobResult;
import com.amazonaws.services.comprehendmedical.model.StartPHIDetectionJobRequest;
import com.amazonaws.services.comprehendmedical.model.StartPHIDetectionJobResult;
import com.amazonaws.services.comprehendmedical.model.StopEntitiesDetectionV2JobRequest;
import com.amazonaws.services.comprehendmedical.model.StopEntitiesDetectionV2JobResult;
import com.amazonaws.services.comprehendmedical.model.StopPHIDetectionJobRequest;
import com.amazonaws.services.comprehendmedical.model.StopPHIDetectionJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSComprehendMedicalAsyncClient
extends AWSComprehendMedicalClient
implements AWSComprehendMedicalAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSComprehendMedicalAsyncClientBuilder asyncBuilder() {
        return AWSComprehendMedicalAsyncClientBuilder.standard();
    }

    AWSComprehendMedicalAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeEntitiesDetectionV2JobResult> describeEntitiesDetectionV2JobAsync(DescribeEntitiesDetectionV2JobRequest request) {
        return this.describeEntitiesDetectionV2JobAsync(request, null);
    }

    @Override
    public Future<DescribeEntitiesDetectionV2JobResult> describeEntitiesDetectionV2JobAsync(DescribeEntitiesDetectionV2JobRequest request, final AsyncHandler<DescribeEntitiesDetectionV2JobRequest, DescribeEntitiesDetectionV2JobResult> asyncHandler) {
        final DescribeEntitiesDetectionV2JobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEntitiesDetectionV2JobResult>(){

            @Override
            public DescribeEntitiesDetectionV2JobResult call() throws Exception {
                DescribeEntitiesDetectionV2JobResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeDescribeEntitiesDetectionV2Job(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePHIDetectionJobResult> describePHIDetectionJobAsync(DescribePHIDetectionJobRequest request) {
        return this.describePHIDetectionJobAsync(request, null);
    }

    @Override
    public Future<DescribePHIDetectionJobResult> describePHIDetectionJobAsync(DescribePHIDetectionJobRequest request, final AsyncHandler<DescribePHIDetectionJobRequest, DescribePHIDetectionJobResult> asyncHandler) {
        final DescribePHIDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePHIDetectionJobResult>(){

            @Override
            public DescribePHIDetectionJobResult call() throws Exception {
                DescribePHIDetectionJobResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeDescribePHIDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<DetectEntitiesResult> detectEntitiesAsync(DetectEntitiesRequest request) {
        return this.detectEntitiesAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<DetectEntitiesResult> detectEntitiesAsync(DetectEntitiesRequest request, final AsyncHandler<DetectEntitiesRequest, DetectEntitiesResult> asyncHandler) {
        final DetectEntitiesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectEntitiesResult>(){

            @Override
            public DetectEntitiesResult call() throws Exception {
                DetectEntitiesResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeDetectEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectEntitiesV2Result> detectEntitiesV2Async(DetectEntitiesV2Request request) {
        return this.detectEntitiesV2Async(request, null);
    }

    @Override
    public Future<DetectEntitiesV2Result> detectEntitiesV2Async(DetectEntitiesV2Request request, final AsyncHandler<DetectEntitiesV2Request, DetectEntitiesV2Result> asyncHandler) {
        final DetectEntitiesV2Request finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectEntitiesV2Result>(){

            @Override
            public DetectEntitiesV2Result call() throws Exception {
                DetectEntitiesV2Result result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeDetectEntitiesV2(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectPHIResult> detectPHIAsync(DetectPHIRequest request) {
        return this.detectPHIAsync(request, null);
    }

    @Override
    public Future<DetectPHIResult> detectPHIAsync(DetectPHIRequest request, final AsyncHandler<DetectPHIRequest, DetectPHIResult> asyncHandler) {
        final DetectPHIRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectPHIResult>(){

            @Override
            public DetectPHIResult call() throws Exception {
                DetectPHIResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeDetectPHI(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEntitiesDetectionV2JobsResult> listEntitiesDetectionV2JobsAsync(ListEntitiesDetectionV2JobsRequest request) {
        return this.listEntitiesDetectionV2JobsAsync(request, null);
    }

    @Override
    public Future<ListEntitiesDetectionV2JobsResult> listEntitiesDetectionV2JobsAsync(ListEntitiesDetectionV2JobsRequest request, final AsyncHandler<ListEntitiesDetectionV2JobsRequest, ListEntitiesDetectionV2JobsResult> asyncHandler) {
        final ListEntitiesDetectionV2JobsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEntitiesDetectionV2JobsResult>(){

            @Override
            public ListEntitiesDetectionV2JobsResult call() throws Exception {
                ListEntitiesDetectionV2JobsResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeListEntitiesDetectionV2Jobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPHIDetectionJobsResult> listPHIDetectionJobsAsync(ListPHIDetectionJobsRequest request) {
        return this.listPHIDetectionJobsAsync(request, null);
    }

    @Override
    public Future<ListPHIDetectionJobsResult> listPHIDetectionJobsAsync(ListPHIDetectionJobsRequest request, final AsyncHandler<ListPHIDetectionJobsRequest, ListPHIDetectionJobsResult> asyncHandler) {
        final ListPHIDetectionJobsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPHIDetectionJobsResult>(){

            @Override
            public ListPHIDetectionJobsResult call() throws Exception {
                ListPHIDetectionJobsResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeListPHIDetectionJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartEntitiesDetectionV2JobResult> startEntitiesDetectionV2JobAsync(StartEntitiesDetectionV2JobRequest request) {
        return this.startEntitiesDetectionV2JobAsync(request, null);
    }

    @Override
    public Future<StartEntitiesDetectionV2JobResult> startEntitiesDetectionV2JobAsync(StartEntitiesDetectionV2JobRequest request, final AsyncHandler<StartEntitiesDetectionV2JobRequest, StartEntitiesDetectionV2JobResult> asyncHandler) {
        final StartEntitiesDetectionV2JobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartEntitiesDetectionV2JobResult>(){

            @Override
            public StartEntitiesDetectionV2JobResult call() throws Exception {
                StartEntitiesDetectionV2JobResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeStartEntitiesDetectionV2Job(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartPHIDetectionJobResult> startPHIDetectionJobAsync(StartPHIDetectionJobRequest request) {
        return this.startPHIDetectionJobAsync(request, null);
    }

    @Override
    public Future<StartPHIDetectionJobResult> startPHIDetectionJobAsync(StartPHIDetectionJobRequest request, final AsyncHandler<StartPHIDetectionJobRequest, StartPHIDetectionJobResult> asyncHandler) {
        final StartPHIDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartPHIDetectionJobResult>(){

            @Override
            public StartPHIDetectionJobResult call() throws Exception {
                StartPHIDetectionJobResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeStartPHIDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopEntitiesDetectionV2JobResult> stopEntitiesDetectionV2JobAsync(StopEntitiesDetectionV2JobRequest request) {
        return this.stopEntitiesDetectionV2JobAsync(request, null);
    }

    @Override
    public Future<StopEntitiesDetectionV2JobResult> stopEntitiesDetectionV2JobAsync(StopEntitiesDetectionV2JobRequest request, final AsyncHandler<StopEntitiesDetectionV2JobRequest, StopEntitiesDetectionV2JobResult> asyncHandler) {
        final StopEntitiesDetectionV2JobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopEntitiesDetectionV2JobResult>(){

            @Override
            public StopEntitiesDetectionV2JobResult call() throws Exception {
                StopEntitiesDetectionV2JobResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeStopEntitiesDetectionV2Job(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopPHIDetectionJobResult> stopPHIDetectionJobAsync(StopPHIDetectionJobRequest request) {
        return this.stopPHIDetectionJobAsync(request, null);
    }

    @Override
    public Future<StopPHIDetectionJobResult> stopPHIDetectionJobAsync(StopPHIDetectionJobRequest request, final AsyncHandler<StopPHIDetectionJobRequest, StopPHIDetectionJobResult> asyncHandler) {
        final StopPHIDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopPHIDetectionJobResult>(){

            @Override
            public StopPHIDetectionJobResult call() throws Exception {
                StopPHIDetectionJobResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeStopPHIDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

