/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.backup.AWSBackup;
import com.amazonaws.services.backup.AWSBackupClientBuilder;
import com.amazonaws.services.backup.model.AWSBackupException;
import com.amazonaws.services.backup.model.CreateBackupPlanRequest;
import com.amazonaws.services.backup.model.CreateBackupPlanResult;
import com.amazonaws.services.backup.model.CreateBackupSelectionRequest;
import com.amazonaws.services.backup.model.CreateBackupSelectionResult;
import com.amazonaws.services.backup.model.CreateBackupVaultRequest;
import com.amazonaws.services.backup.model.CreateBackupVaultResult;
import com.amazonaws.services.backup.model.DeleteBackupPlanRequest;
import com.amazonaws.services.backup.model.DeleteBackupPlanResult;
import com.amazonaws.services.backup.model.DeleteBackupSelectionRequest;
import com.amazonaws.services.backup.model.DeleteBackupSelectionResult;
import com.amazonaws.services.backup.model.DeleteBackupVaultAccessPolicyRequest;
import com.amazonaws.services.backup.model.DeleteBackupVaultAccessPolicyResult;
import com.amazonaws.services.backup.model.DeleteBackupVaultNotificationsRequest;
import com.amazonaws.services.backup.model.DeleteBackupVaultNotificationsResult;
import com.amazonaws.services.backup.model.DeleteBackupVaultRequest;
import com.amazonaws.services.backup.model.DeleteBackupVaultResult;
import com.amazonaws.services.backup.model.DeleteRecoveryPointRequest;
import com.amazonaws.services.backup.model.DeleteRecoveryPointResult;
import com.amazonaws.services.backup.model.DescribeBackupJobRequest;
import com.amazonaws.services.backup.model.DescribeBackupJobResult;
import com.amazonaws.services.backup.model.DescribeBackupVaultRequest;
import com.amazonaws.services.backup.model.DescribeBackupVaultResult;
import com.amazonaws.services.backup.model.DescribeProtectedResourceRequest;
import com.amazonaws.services.backup.model.DescribeProtectedResourceResult;
import com.amazonaws.services.backup.model.DescribeRecoveryPointRequest;
import com.amazonaws.services.backup.model.DescribeRecoveryPointResult;
import com.amazonaws.services.backup.model.DescribeRestoreJobRequest;
import com.amazonaws.services.backup.model.DescribeRestoreJobResult;
import com.amazonaws.services.backup.model.ExportBackupPlanTemplateRequest;
import com.amazonaws.services.backup.model.ExportBackupPlanTemplateResult;
import com.amazonaws.services.backup.model.GetBackupPlanFromJSONRequest;
import com.amazonaws.services.backup.model.GetBackupPlanFromJSONResult;
import com.amazonaws.services.backup.model.GetBackupPlanFromTemplateRequest;
import com.amazonaws.services.backup.model.GetBackupPlanFromTemplateResult;
import com.amazonaws.services.backup.model.GetBackupPlanRequest;
import com.amazonaws.services.backup.model.GetBackupPlanResult;
import com.amazonaws.services.backup.model.GetBackupSelectionRequest;
import com.amazonaws.services.backup.model.GetBackupSelectionResult;
import com.amazonaws.services.backup.model.GetBackupVaultAccessPolicyRequest;
import com.amazonaws.services.backup.model.GetBackupVaultAccessPolicyResult;
import com.amazonaws.services.backup.model.GetBackupVaultNotificationsRequest;
import com.amazonaws.services.backup.model.GetBackupVaultNotificationsResult;
import com.amazonaws.services.backup.model.GetRecoveryPointRestoreMetadataRequest;
import com.amazonaws.services.backup.model.GetRecoveryPointRestoreMetadataResult;
import com.amazonaws.services.backup.model.GetSupportedResourceTypesRequest;
import com.amazonaws.services.backup.model.GetSupportedResourceTypesResult;
import com.amazonaws.services.backup.model.ListBackupJobsRequest;
import com.amazonaws.services.backup.model.ListBackupJobsResult;
import com.amazonaws.services.backup.model.ListBackupPlanTemplatesRequest;
import com.amazonaws.services.backup.model.ListBackupPlanTemplatesResult;
import com.amazonaws.services.backup.model.ListBackupPlanVersionsRequest;
import com.amazonaws.services.backup.model.ListBackupPlanVersionsResult;
import com.amazonaws.services.backup.model.ListBackupPlansRequest;
import com.amazonaws.services.backup.model.ListBackupPlansResult;
import com.amazonaws.services.backup.model.ListBackupSelectionsRequest;
import com.amazonaws.services.backup.model.ListBackupSelectionsResult;
import com.amazonaws.services.backup.model.ListBackupVaultsRequest;
import com.amazonaws.services.backup.model.ListBackupVaultsResult;
import com.amazonaws.services.backup.model.ListProtectedResourcesRequest;
import com.amazonaws.services.backup.model.ListProtectedResourcesResult;
import com.amazonaws.services.backup.model.ListRecoveryPointsByBackupVaultRequest;
import com.amazonaws.services.backup.model.ListRecoveryPointsByBackupVaultResult;
import com.amazonaws.services.backup.model.ListRecoveryPointsByResourceRequest;
import com.amazonaws.services.backup.model.ListRecoveryPointsByResourceResult;
import com.amazonaws.services.backup.model.ListRestoreJobsRequest;
import com.amazonaws.services.backup.model.ListRestoreJobsResult;
import com.amazonaws.services.backup.model.ListTagsRequest;
import com.amazonaws.services.backup.model.ListTagsResult;
import com.amazonaws.services.backup.model.PutBackupVaultAccessPolicyRequest;
import com.amazonaws.services.backup.model.PutBackupVaultAccessPolicyResult;
import com.amazonaws.services.backup.model.PutBackupVaultNotificationsRequest;
import com.amazonaws.services.backup.model.PutBackupVaultNotificationsResult;
import com.amazonaws.services.backup.model.StartBackupJobRequest;
import com.amazonaws.services.backup.model.StartBackupJobResult;
import com.amazonaws.services.backup.model.StartRestoreJobRequest;
import com.amazonaws.services.backup.model.StartRestoreJobResult;
import com.amazonaws.services.backup.model.StopBackupJobRequest;
import com.amazonaws.services.backup.model.StopBackupJobResult;
import com.amazonaws.services.backup.model.TagResourceRequest;
import com.amazonaws.services.backup.model.TagResourceResult;
import com.amazonaws.services.backup.model.UntagResourceRequest;
import com.amazonaws.services.backup.model.UntagResourceResult;
import com.amazonaws.services.backup.model.UpdateBackupPlanRequest;
import com.amazonaws.services.backup.model.UpdateBackupPlanResult;
import com.amazonaws.services.backup.model.UpdateRecoveryPointLifecycleRequest;
import com.amazonaws.services.backup.model.UpdateRecoveryPointLifecycleResult;
import com.amazonaws.services.backup.model.transform.AlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.backup.model.transform.CreateBackupPlanRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.CreateBackupPlanResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.CreateBackupSelectionRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.CreateBackupSelectionResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.CreateBackupVaultRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.CreateBackupVaultResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.DeleteBackupPlanRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.DeleteBackupPlanResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.DeleteBackupSelectionRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.DeleteBackupSelectionResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.DeleteBackupVaultAccessPolicyRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.DeleteBackupVaultAccessPolicyResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.DeleteBackupVaultNotificationsRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.DeleteBackupVaultNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.DeleteBackupVaultRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.DeleteBackupVaultResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.DeleteRecoveryPointRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.DeleteRecoveryPointResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.DependencyFailureExceptionUnmarshaller;
import com.amazonaws.services.backup.model.transform.DescribeBackupJobRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.DescribeBackupJobResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.DescribeBackupVaultRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.DescribeBackupVaultResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.DescribeProtectedResourceRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.DescribeProtectedResourceResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.DescribeRecoveryPointRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.DescribeRecoveryPointResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.DescribeRestoreJobRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.DescribeRestoreJobResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ExportBackupPlanTemplateRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ExportBackupPlanTemplateResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupPlanFromJSONRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupPlanFromJSONResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupPlanFromTemplateRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupPlanFromTemplateResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupPlanRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupPlanResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupSelectionRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupSelectionResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupVaultAccessPolicyRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupVaultAccessPolicyResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupVaultNotificationsRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.GetBackupVaultNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.GetRecoveryPointRestoreMetadataRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.GetRecoveryPointRestoreMetadataResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.GetSupportedResourceTypesRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.GetSupportedResourceTypesResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.backup.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.backup.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupJobsRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupJobsResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupPlanTemplatesRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupPlanTemplatesResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupPlanVersionsRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupPlanVersionsResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupPlansRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupPlansResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupSelectionsRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupSelectionsResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupVaultsRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ListBackupVaultsResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ListProtectedResourcesRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ListProtectedResourcesResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ListRecoveryPointsByBackupVaultRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ListRecoveryPointsByBackupVaultResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ListRecoveryPointsByResourceRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ListRecoveryPointsByResourceResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ListRestoreJobsRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ListRestoreJobsResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ListTagsRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.ListTagsResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.MissingParameterValueExceptionUnmarshaller;
import com.amazonaws.services.backup.model.transform.PutBackupVaultAccessPolicyRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.PutBackupVaultAccessPolicyResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.PutBackupVaultNotificationsRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.PutBackupVaultNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.backup.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.backup.model.transform.StartBackupJobRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.StartBackupJobResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.StartRestoreJobRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.StartRestoreJobResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.StopBackupJobRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.StopBackupJobResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.UpdateBackupPlanRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.UpdateBackupPlanResultJsonUnmarshaller;
import com.amazonaws.services.backup.model.transform.UpdateRecoveryPointLifecycleRequestProtocolMarshaller;
import com.amazonaws.services.backup.model.transform.UpdateRecoveryPointLifecycleResultJsonUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AWSBackupClient
extends AmazonWebServiceClient
implements AWSBackup {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSBackup.class);
    private static final String DEFAULT_SIGNING_NAME = "backup";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingParameterValueException").withExceptionUnmarshaller(MissingParameterValueExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withExceptionUnmarshaller(InvalidParameterValueExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller(InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller(LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DependencyFailureException").withExceptionUnmarshaller(DependencyFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AlreadyExistsException").withExceptionUnmarshaller(AlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller(ServiceUnavailableExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSBackupException.class));

    public static AWSBackupClientBuilder builder() {
        return AWSBackupClientBuilder.standard();
    }

    AWSBackupClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSBackupClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("backup.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/backup/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/backup/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateBackupPlanResult createBackupPlan(CreateBackupPlanRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateBackupPlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBackupPlanResult executeCreateBackupPlan(CreateBackupPlanRequest createBackupPlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBackupPlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBackupPlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBackupPlanRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createBackupPlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateBackupPlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateBackupPlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBackupPlanResult createBackupPlanResult = (CreateBackupPlanResult)response.getAwsResponse();
            return createBackupPlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateBackupSelectionResult createBackupSelection(CreateBackupSelectionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateBackupSelection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBackupSelectionResult executeCreateBackupSelection(CreateBackupSelectionRequest createBackupSelectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBackupSelectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBackupSelectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBackupSelectionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createBackupSelectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateBackupSelection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateBackupSelectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBackupSelectionResult createBackupSelectionResult = (CreateBackupSelectionResult)response.getAwsResponse();
            return createBackupSelectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateBackupVaultResult createBackupVault(CreateBackupVaultRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateBackupVault(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBackupVaultResult executeCreateBackupVault(CreateBackupVaultRequest createBackupVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBackupVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBackupVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBackupVaultRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createBackupVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateBackupVault");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateBackupVaultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBackupVaultResult createBackupVaultResult = (CreateBackupVaultResult)response.getAwsResponse();
            return createBackupVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBackupPlanResult deleteBackupPlan(DeleteBackupPlanRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteBackupPlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBackupPlanResult executeDeleteBackupPlan(DeleteBackupPlanRequest deleteBackupPlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackupPlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackupPlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackupPlanRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteBackupPlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBackupPlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteBackupPlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackupPlanResult deleteBackupPlanResult = (DeleteBackupPlanResult)response.getAwsResponse();
            return deleteBackupPlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBackupSelectionResult deleteBackupSelection(DeleteBackupSelectionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteBackupSelection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBackupSelectionResult executeDeleteBackupSelection(DeleteBackupSelectionRequest deleteBackupSelectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackupSelectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackupSelectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackupSelectionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteBackupSelectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBackupSelection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteBackupSelectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackupSelectionResult deleteBackupSelectionResult = (DeleteBackupSelectionResult)response.getAwsResponse();
            return deleteBackupSelectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBackupVaultResult deleteBackupVault(DeleteBackupVaultRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteBackupVault(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBackupVaultResult executeDeleteBackupVault(DeleteBackupVaultRequest deleteBackupVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackupVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackupVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackupVaultRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteBackupVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBackupVault");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteBackupVaultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackupVaultResult deleteBackupVaultResult = (DeleteBackupVaultResult)response.getAwsResponse();
            return deleteBackupVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBackupVaultAccessPolicyResult deleteBackupVaultAccessPolicy(DeleteBackupVaultAccessPolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteBackupVaultAccessPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBackupVaultAccessPolicyResult executeDeleteBackupVaultAccessPolicy(DeleteBackupVaultAccessPolicyRequest deleteBackupVaultAccessPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackupVaultAccessPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackupVaultAccessPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackupVaultAccessPolicyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteBackupVaultAccessPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBackupVaultAccessPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteBackupVaultAccessPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackupVaultAccessPolicyResult deleteBackupVaultAccessPolicyResult = (DeleteBackupVaultAccessPolicyResult)response.getAwsResponse();
            return deleteBackupVaultAccessPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBackupVaultNotificationsResult deleteBackupVaultNotifications(DeleteBackupVaultNotificationsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteBackupVaultNotifications(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBackupVaultNotificationsResult executeDeleteBackupVaultNotifications(DeleteBackupVaultNotificationsRequest deleteBackupVaultNotificationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackupVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackupVaultNotificationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackupVaultNotificationsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteBackupVaultNotificationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBackupVaultNotifications");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteBackupVaultNotificationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackupVaultNotificationsResult deleteBackupVaultNotificationsResult = (DeleteBackupVaultNotificationsResult)response.getAwsResponse();
            return deleteBackupVaultNotificationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRecoveryPointResult deleteRecoveryPoint(DeleteRecoveryPointRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteRecoveryPoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRecoveryPointResult executeDeleteRecoveryPoint(DeleteRecoveryPointRequest deleteRecoveryPointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRecoveryPointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRecoveryPointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRecoveryPointRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteRecoveryPointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteRecoveryPoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteRecoveryPointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRecoveryPointResult deleteRecoveryPointResult = (DeleteRecoveryPointResult)response.getAwsResponse();
            return deleteRecoveryPointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBackupJobResult describeBackupJob(DescribeBackupJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeBackupJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBackupJobResult executeDescribeBackupJob(DescribeBackupJobRequest describeBackupJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBackupJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBackupJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBackupJobRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeBackupJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeBackupJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeBackupJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBackupJobResult describeBackupJobResult = (DescribeBackupJobResult)response.getAwsResponse();
            return describeBackupJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBackupVaultResult describeBackupVault(DescribeBackupVaultRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeBackupVault(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBackupVaultResult executeDescribeBackupVault(DescribeBackupVaultRequest describeBackupVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBackupVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBackupVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBackupVaultRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeBackupVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeBackupVault");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeBackupVaultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBackupVaultResult describeBackupVaultResult = (DescribeBackupVaultResult)response.getAwsResponse();
            return describeBackupVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeProtectedResourceResult describeProtectedResource(DescribeProtectedResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeProtectedResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeProtectedResourceResult executeDescribeProtectedResource(DescribeProtectedResourceRequest describeProtectedResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProtectedResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProtectedResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProtectedResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeProtectedResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeProtectedResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeProtectedResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProtectedResourceResult describeProtectedResourceResult = (DescribeProtectedResourceResult)response.getAwsResponse();
            return describeProtectedResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRecoveryPointResult describeRecoveryPoint(DescribeRecoveryPointRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeRecoveryPoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRecoveryPointResult executeDescribeRecoveryPoint(DescribeRecoveryPointRequest describeRecoveryPointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRecoveryPointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRecoveryPointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRecoveryPointRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeRecoveryPointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeRecoveryPoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeRecoveryPointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRecoveryPointResult describeRecoveryPointResult = (DescribeRecoveryPointResult)response.getAwsResponse();
            return describeRecoveryPointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRestoreJobResult describeRestoreJob(DescribeRestoreJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeRestoreJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRestoreJobResult executeDescribeRestoreJob(DescribeRestoreJobRequest describeRestoreJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRestoreJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRestoreJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRestoreJobRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeRestoreJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeRestoreJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeRestoreJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRestoreJobResult describeRestoreJobResult = (DescribeRestoreJobResult)response.getAwsResponse();
            return describeRestoreJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportBackupPlanTemplateResult exportBackupPlanTemplate(ExportBackupPlanTemplateRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeExportBackupPlanTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportBackupPlanTemplateResult executeExportBackupPlanTemplate(ExportBackupPlanTemplateRequest exportBackupPlanTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportBackupPlanTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportBackupPlanTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportBackupPlanTemplateRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(exportBackupPlanTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ExportBackupPlanTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ExportBackupPlanTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportBackupPlanTemplateResult exportBackupPlanTemplateResult = (ExportBackupPlanTemplateResult)response.getAwsResponse();
            return exportBackupPlanTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBackupPlanResult getBackupPlan(GetBackupPlanRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetBackupPlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBackupPlanResult executeGetBackupPlan(GetBackupPlanRequest getBackupPlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBackupPlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBackupPlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBackupPlanRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getBackupPlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBackupPlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetBackupPlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBackupPlanResult getBackupPlanResult = (GetBackupPlanResult)response.getAwsResponse();
            return getBackupPlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBackupPlanFromJSONResult getBackupPlanFromJSON(GetBackupPlanFromJSONRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetBackupPlanFromJSON(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBackupPlanFromJSONResult executeGetBackupPlanFromJSON(GetBackupPlanFromJSONRequest getBackupPlanFromJSONRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBackupPlanFromJSONRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBackupPlanFromJSONRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBackupPlanFromJSONRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getBackupPlanFromJSONRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBackupPlanFromJSON");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetBackupPlanFromJSONResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBackupPlanFromJSONResult getBackupPlanFromJSONResult = (GetBackupPlanFromJSONResult)response.getAwsResponse();
            return getBackupPlanFromJSONResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBackupPlanFromTemplateResult getBackupPlanFromTemplate(GetBackupPlanFromTemplateRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetBackupPlanFromTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBackupPlanFromTemplateResult executeGetBackupPlanFromTemplate(GetBackupPlanFromTemplateRequest getBackupPlanFromTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBackupPlanFromTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBackupPlanFromTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBackupPlanFromTemplateRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getBackupPlanFromTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBackupPlanFromTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetBackupPlanFromTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBackupPlanFromTemplateResult getBackupPlanFromTemplateResult = (GetBackupPlanFromTemplateResult)response.getAwsResponse();
            return getBackupPlanFromTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBackupSelectionResult getBackupSelection(GetBackupSelectionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetBackupSelection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBackupSelectionResult executeGetBackupSelection(GetBackupSelectionRequest getBackupSelectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBackupSelectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBackupSelectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBackupSelectionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getBackupSelectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBackupSelection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetBackupSelectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBackupSelectionResult getBackupSelectionResult = (GetBackupSelectionResult)response.getAwsResponse();
            return getBackupSelectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBackupVaultAccessPolicyResult getBackupVaultAccessPolicy(GetBackupVaultAccessPolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetBackupVaultAccessPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBackupVaultAccessPolicyResult executeGetBackupVaultAccessPolicy(GetBackupVaultAccessPolicyRequest getBackupVaultAccessPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBackupVaultAccessPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBackupVaultAccessPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBackupVaultAccessPolicyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getBackupVaultAccessPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBackupVaultAccessPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetBackupVaultAccessPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBackupVaultAccessPolicyResult getBackupVaultAccessPolicyResult = (GetBackupVaultAccessPolicyResult)response.getAwsResponse();
            return getBackupVaultAccessPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBackupVaultNotificationsResult getBackupVaultNotifications(GetBackupVaultNotificationsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetBackupVaultNotifications(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBackupVaultNotificationsResult executeGetBackupVaultNotifications(GetBackupVaultNotificationsRequest getBackupVaultNotificationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBackupVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBackupVaultNotificationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBackupVaultNotificationsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getBackupVaultNotificationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBackupVaultNotifications");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetBackupVaultNotificationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBackupVaultNotificationsResult getBackupVaultNotificationsResult = (GetBackupVaultNotificationsResult)response.getAwsResponse();
            return getBackupVaultNotificationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRecoveryPointRestoreMetadataResult getRecoveryPointRestoreMetadata(GetRecoveryPointRestoreMetadataRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetRecoveryPointRestoreMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRecoveryPointRestoreMetadataResult executeGetRecoveryPointRestoreMetadata(GetRecoveryPointRestoreMetadataRequest getRecoveryPointRestoreMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRecoveryPointRestoreMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRecoveryPointRestoreMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRecoveryPointRestoreMetadataRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getRecoveryPointRestoreMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetRecoveryPointRestoreMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetRecoveryPointRestoreMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRecoveryPointRestoreMetadataResult getRecoveryPointRestoreMetadataResult = (GetRecoveryPointRestoreMetadataResult)response.getAwsResponse();
            return getRecoveryPointRestoreMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSupportedResourceTypesResult getSupportedResourceTypes(GetSupportedResourceTypesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetSupportedResourceTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSupportedResourceTypesResult executeGetSupportedResourceTypes(GetSupportedResourceTypesRequest getSupportedResourceTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSupportedResourceTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSupportedResourceTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSupportedResourceTypesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getSupportedResourceTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetSupportedResourceTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetSupportedResourceTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSupportedResourceTypesResult getSupportedResourceTypesResult = (GetSupportedResourceTypesResult)response.getAwsResponse();
            return getSupportedResourceTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBackupJobsResult listBackupJobs(ListBackupJobsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListBackupJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBackupJobsResult executeListBackupJobs(ListBackupJobsRequest listBackupJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBackupJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBackupJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBackupJobsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listBackupJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBackupJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListBackupJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBackupJobsResult listBackupJobsResult = (ListBackupJobsResult)response.getAwsResponse();
            return listBackupJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBackupPlanTemplatesResult listBackupPlanTemplates(ListBackupPlanTemplatesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListBackupPlanTemplates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBackupPlanTemplatesResult executeListBackupPlanTemplates(ListBackupPlanTemplatesRequest listBackupPlanTemplatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBackupPlanTemplatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBackupPlanTemplatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBackupPlanTemplatesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listBackupPlanTemplatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBackupPlanTemplates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListBackupPlanTemplatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBackupPlanTemplatesResult listBackupPlanTemplatesResult = (ListBackupPlanTemplatesResult)response.getAwsResponse();
            return listBackupPlanTemplatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBackupPlanVersionsResult listBackupPlanVersions(ListBackupPlanVersionsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListBackupPlanVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBackupPlanVersionsResult executeListBackupPlanVersions(ListBackupPlanVersionsRequest listBackupPlanVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBackupPlanVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBackupPlanVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBackupPlanVersionsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listBackupPlanVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBackupPlanVersions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListBackupPlanVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBackupPlanVersionsResult listBackupPlanVersionsResult = (ListBackupPlanVersionsResult)response.getAwsResponse();
            return listBackupPlanVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBackupPlansResult listBackupPlans(ListBackupPlansRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListBackupPlans(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBackupPlansResult executeListBackupPlans(ListBackupPlansRequest listBackupPlansRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBackupPlansRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBackupPlansRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBackupPlansRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listBackupPlansRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBackupPlans");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListBackupPlansResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBackupPlansResult listBackupPlansResult = (ListBackupPlansResult)response.getAwsResponse();
            return listBackupPlansResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBackupSelectionsResult listBackupSelections(ListBackupSelectionsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListBackupSelections(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBackupSelectionsResult executeListBackupSelections(ListBackupSelectionsRequest listBackupSelectionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBackupSelectionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBackupSelectionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBackupSelectionsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listBackupSelectionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBackupSelections");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListBackupSelectionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBackupSelectionsResult listBackupSelectionsResult = (ListBackupSelectionsResult)response.getAwsResponse();
            return listBackupSelectionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBackupVaultsResult listBackupVaults(ListBackupVaultsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListBackupVaults(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBackupVaultsResult executeListBackupVaults(ListBackupVaultsRequest listBackupVaultsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBackupVaultsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBackupVaultsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBackupVaultsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listBackupVaultsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBackupVaults");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListBackupVaultsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBackupVaultsResult listBackupVaultsResult = (ListBackupVaultsResult)response.getAwsResponse();
            return listBackupVaultsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProtectedResourcesResult listProtectedResources(ListProtectedResourcesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListProtectedResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProtectedResourcesResult executeListProtectedResources(ListProtectedResourcesRequest listProtectedResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProtectedResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProtectedResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProtectedResourcesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listProtectedResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListProtectedResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListProtectedResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProtectedResourcesResult listProtectedResourcesResult = (ListProtectedResourcesResult)response.getAwsResponse();
            return listProtectedResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecoveryPointsByBackupVaultResult listRecoveryPointsByBackupVault(ListRecoveryPointsByBackupVaultRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListRecoveryPointsByBackupVault(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecoveryPointsByBackupVaultResult executeListRecoveryPointsByBackupVault(ListRecoveryPointsByBackupVaultRequest listRecoveryPointsByBackupVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecoveryPointsByBackupVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecoveryPointsByBackupVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecoveryPointsByBackupVaultRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listRecoveryPointsByBackupVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListRecoveryPointsByBackupVault");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListRecoveryPointsByBackupVaultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecoveryPointsByBackupVaultResult listRecoveryPointsByBackupVaultResult = (ListRecoveryPointsByBackupVaultResult)response.getAwsResponse();
            return listRecoveryPointsByBackupVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecoveryPointsByResourceResult listRecoveryPointsByResource(ListRecoveryPointsByResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListRecoveryPointsByResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecoveryPointsByResourceResult executeListRecoveryPointsByResource(ListRecoveryPointsByResourceRequest listRecoveryPointsByResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecoveryPointsByResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecoveryPointsByResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecoveryPointsByResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listRecoveryPointsByResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListRecoveryPointsByResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListRecoveryPointsByResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecoveryPointsByResourceResult listRecoveryPointsByResourceResult = (ListRecoveryPointsByResourceResult)response.getAwsResponse();
            return listRecoveryPointsByResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRestoreJobsResult listRestoreJobs(ListRestoreJobsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListRestoreJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRestoreJobsResult executeListRestoreJobs(ListRestoreJobsRequest listRestoreJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRestoreJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRestoreJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRestoreJobsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listRestoreJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListRestoreJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListRestoreJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRestoreJobsResult listRestoreJobsResult = (ListRestoreJobsResult)response.getAwsResponse();
            return listRestoreJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsResult listTags(ListTagsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsResult executeListTags(ListTagsRequest listTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTags");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsResult listTagsResult = (ListTagsResult)response.getAwsResponse();
            return listTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutBackupVaultAccessPolicyResult putBackupVaultAccessPolicy(PutBackupVaultAccessPolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutBackupVaultAccessPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutBackupVaultAccessPolicyResult executePutBackupVaultAccessPolicy(PutBackupVaultAccessPolicyRequest putBackupVaultAccessPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putBackupVaultAccessPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutBackupVaultAccessPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutBackupVaultAccessPolicyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putBackupVaultAccessPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBackupVaultAccessPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutBackupVaultAccessPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutBackupVaultAccessPolicyResult putBackupVaultAccessPolicyResult = (PutBackupVaultAccessPolicyResult)response.getAwsResponse();
            return putBackupVaultAccessPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutBackupVaultNotificationsResult putBackupVaultNotifications(PutBackupVaultNotificationsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutBackupVaultNotifications(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutBackupVaultNotificationsResult executePutBackupVaultNotifications(PutBackupVaultNotificationsRequest putBackupVaultNotificationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putBackupVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutBackupVaultNotificationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutBackupVaultNotificationsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putBackupVaultNotificationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBackupVaultNotifications");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutBackupVaultNotificationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutBackupVaultNotificationsResult putBackupVaultNotificationsResult = (PutBackupVaultNotificationsResult)response.getAwsResponse();
            return putBackupVaultNotificationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartBackupJobResult startBackupJob(StartBackupJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartBackupJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartBackupJobResult executeStartBackupJob(StartBackupJobRequest startBackupJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startBackupJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartBackupJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartBackupJobRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startBackupJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StartBackupJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartBackupJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartBackupJobResult startBackupJobResult = (StartBackupJobResult)response.getAwsResponse();
            return startBackupJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartRestoreJobResult startRestoreJob(StartRestoreJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartRestoreJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartRestoreJobResult executeStartRestoreJob(StartRestoreJobRequest startRestoreJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startRestoreJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartRestoreJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartRestoreJobRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startRestoreJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StartRestoreJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartRestoreJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartRestoreJobResult startRestoreJobResult = (StartRestoreJobResult)response.getAwsResponse();
            return startRestoreJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopBackupJobResult stopBackupJob(StopBackupJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStopBackupJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopBackupJobResult executeStopBackupJob(StopBackupJobRequest stopBackupJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopBackupJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopBackupJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopBackupJobRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(stopBackupJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StopBackupJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StopBackupJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopBackupJobResult stopBackupJobResult = (StopBackupJobResult)response.getAwsResponse();
            return stopBackupJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateBackupPlanResult updateBackupPlan(UpdateBackupPlanRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateBackupPlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateBackupPlanResult executeUpdateBackupPlan(UpdateBackupPlanRequest updateBackupPlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateBackupPlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateBackupPlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateBackupPlanRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateBackupPlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateBackupPlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateBackupPlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateBackupPlanResult updateBackupPlanResult = (UpdateBackupPlanResult)response.getAwsResponse();
            return updateBackupPlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRecoveryPointLifecycleResult updateRecoveryPointLifecycle(UpdateRecoveryPointLifecycleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateRecoveryPointLifecycle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRecoveryPointLifecycleResult executeUpdateRecoveryPointLifecycle(UpdateRecoveryPointLifecycleRequest updateRecoveryPointLifecycleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRecoveryPointLifecycleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRecoveryPointLifecycleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRecoveryPointLifecycleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateRecoveryPointLifecycleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Backup");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateRecoveryPointLifecycle");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateRecoveryPointLifecycleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRecoveryPointLifecycleResult updateRecoveryPointLifecycleResult = (UpdateRecoveryPointLifecycleResult)response.getAwsResponse();
            return updateRecoveryPointLifecycleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

