/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appmesh.model.ServiceDiscovery;

@SdkInternalApi
public class ServiceDiscoveryMarshaller {
    private static final MarshallingInfo<StructuredPojo> AWSCLOUDMAP_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsCloudMap").build();
    private static final MarshallingInfo<StructuredPojo> DNS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dns").build();
    private static final ServiceDiscoveryMarshaller instance = new ServiceDiscoveryMarshaller();

    public static ServiceDiscoveryMarshaller getInstance() {
        return instance;
    }

    public void marshall(ServiceDiscovery serviceDiscovery, ProtocolMarshaller protocolMarshaller) {
        if (serviceDiscovery == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(serviceDiscovery.getAwsCloudMap(), AWSCLOUDMAP_BINDING);
            protocolMarshaller.marshall(serviceDiscovery.getDns(), DNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

