/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appmesh.model.RouteSpec;

@SdkInternalApi
public class RouteSpecMarshaller {
    private static final MarshallingInfo<StructuredPojo> GRPCROUTE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("grpcRoute").build();
    private static final MarshallingInfo<StructuredPojo> HTTP2ROUTE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("http2Route").build();
    private static final MarshallingInfo<StructuredPojo> HTTPROUTE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpRoute").build();
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("priority").build();
    private static final MarshallingInfo<StructuredPojo> TCPROUTE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tcpRoute").build();
    private static final RouteSpecMarshaller instance = new RouteSpecMarshaller();

    public static RouteSpecMarshaller getInstance() {
        return instance;
    }

    public void marshall(RouteSpec routeSpec, ProtocolMarshaller protocolMarshaller) {
        if (routeSpec == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(routeSpec.getGrpcRoute(), GRPCROUTE_BINDING);
            protocolMarshaller.marshall(routeSpec.getHttp2Route(), HTTP2ROUTE_BINDING);
            protocolMarshaller.marshall(routeSpec.getHttpRoute(), HTTPROUTE_BINDING);
            protocolMarshaller.marshall(routeSpec.getPriority(), PRIORITY_BINDING);
            protocolMarshaller.marshall(routeSpec.getTcpRoute(), TCPROUTE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

