/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appmesh.model.HttpMethod;
import com.amazonaws.services.appmesh.model.HttpRouteHeader;
import com.amazonaws.services.appmesh.model.HttpScheme;
import com.amazonaws.services.appmesh.model.transform.HttpRouteMatchMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HttpRouteMatch
implements Serializable,
Cloneable,
StructuredPojo {
    private List<HttpRouteHeader> headers;
    private String method;
    private String prefix;
    private String scheme;

    public List<HttpRouteHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Collection<HttpRouteHeader> headers) {
        if (headers == null) {
            this.headers = null;
            return;
        }
        this.headers = new ArrayList<HttpRouteHeader>(headers);
    }

    public HttpRouteMatch withHeaders(HttpRouteHeader ... headers) {
        if (this.headers == null) {
            this.setHeaders(new ArrayList<HttpRouteHeader>(headers.length));
        }
        for (HttpRouteHeader ele : headers) {
            this.headers.add(ele);
        }
        return this;
    }

    public HttpRouteMatch withHeaders(Collection<HttpRouteHeader> headers) {
        this.setHeaders(headers);
        return this;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpRouteMatch withMethod(String method) {
        this.setMethod(method);
        return this;
    }

    public HttpRouteMatch withMethod(HttpMethod method) {
        this.method = method.toString();
        return this;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public HttpRouteMatch withPrefix(String prefix) {
        this.setPrefix(prefix);
        return this;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public HttpRouteMatch withScheme(String scheme) {
        this.setScheme(scheme);
        return this;
    }

    public HttpRouteMatch withScheme(HttpScheme scheme) {
        this.scheme = scheme.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHeaders() != null) {
            sb.append("Headers: ").append(this.getHeaders()).append(",");
        }
        if (this.getMethod() != null) {
            sb.append("Method: ").append(this.getMethod()).append(",");
        }
        if (this.getPrefix() != null) {
            sb.append("Prefix: ").append(this.getPrefix()).append(",");
        }
        if (this.getScheme() != null) {
            sb.append("Scheme: ").append(this.getScheme());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRouteMatch)) {
            return false;
        }
        HttpRouteMatch other = (HttpRouteMatch)obj;
        if (other.getHeaders() == null ^ this.getHeaders() == null) {
            return false;
        }
        if (other.getHeaders() != null && !other.getHeaders().equals(this.getHeaders())) {
            return false;
        }
        if (other.getMethod() == null ^ this.getMethod() == null) {
            return false;
        }
        if (other.getMethod() != null && !other.getMethod().equals(this.getMethod())) {
            return false;
        }
        if (other.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        if (other.getPrefix() != null && !other.getPrefix().equals(this.getPrefix())) {
            return false;
        }
        if (other.getScheme() == null ^ this.getScheme() == null) {
            return false;
        }
        return other.getScheme() == null || other.getScheme().equals(this.getScheme());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHeaders() == null ? 0 : this.getHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getMethod() == null ? 0 : this.getMethod().hashCode());
        hashCode = 31 * hashCode + (this.getPrefix() == null ? 0 : this.getPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getScheme() == null ? 0 : this.getScheme().hashCode());
        return hashCode;
    }

    public HttpRouteMatch clone() {
        try {
            return (HttpRouteMatch)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HttpRouteMatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

