/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appmesh.model.Duration;
import com.amazonaws.services.appmesh.model.GrpcRetryPolicyEvent;
import com.amazonaws.services.appmesh.model.TcpRetryPolicyEvent;
import com.amazonaws.services.appmesh.model.transform.GrpcRetryPolicyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GrpcRetryPolicy
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> grpcRetryEvents;
    private List<String> httpRetryEvents;
    private Long maxRetries;
    private Duration perRetryTimeout;
    private List<String> tcpRetryEvents;

    public List<String> getGrpcRetryEvents() {
        return this.grpcRetryEvents;
    }

    public void setGrpcRetryEvents(Collection<String> grpcRetryEvents) {
        if (grpcRetryEvents == null) {
            this.grpcRetryEvents = null;
            return;
        }
        this.grpcRetryEvents = new ArrayList<String>(grpcRetryEvents);
    }

    public GrpcRetryPolicy withGrpcRetryEvents(String ... grpcRetryEvents) {
        if (this.grpcRetryEvents == null) {
            this.setGrpcRetryEvents(new ArrayList<String>(grpcRetryEvents.length));
        }
        for (String ele : grpcRetryEvents) {
            this.grpcRetryEvents.add(ele);
        }
        return this;
    }

    public GrpcRetryPolicy withGrpcRetryEvents(Collection<String> grpcRetryEvents) {
        this.setGrpcRetryEvents(grpcRetryEvents);
        return this;
    }

    public GrpcRetryPolicy withGrpcRetryEvents(GrpcRetryPolicyEvent ... grpcRetryEvents) {
        ArrayList<String> grpcRetryEventsCopy = new ArrayList<String>(grpcRetryEvents.length);
        for (GrpcRetryPolicyEvent value : grpcRetryEvents) {
            grpcRetryEventsCopy.add(value.toString());
        }
        if (this.getGrpcRetryEvents() == null) {
            this.setGrpcRetryEvents(grpcRetryEventsCopy);
        } else {
            this.getGrpcRetryEvents().addAll(grpcRetryEventsCopy);
        }
        return this;
    }

    public List<String> getHttpRetryEvents() {
        return this.httpRetryEvents;
    }

    public void setHttpRetryEvents(Collection<String> httpRetryEvents) {
        if (httpRetryEvents == null) {
            this.httpRetryEvents = null;
            return;
        }
        this.httpRetryEvents = new ArrayList<String>(httpRetryEvents);
    }

    public GrpcRetryPolicy withHttpRetryEvents(String ... httpRetryEvents) {
        if (this.httpRetryEvents == null) {
            this.setHttpRetryEvents(new ArrayList<String>(httpRetryEvents.length));
        }
        for (String ele : httpRetryEvents) {
            this.httpRetryEvents.add(ele);
        }
        return this;
    }

    public GrpcRetryPolicy withHttpRetryEvents(Collection<String> httpRetryEvents) {
        this.setHttpRetryEvents(httpRetryEvents);
        return this;
    }

    public void setMaxRetries(Long maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Long getMaxRetries() {
        return this.maxRetries;
    }

    public GrpcRetryPolicy withMaxRetries(Long maxRetries) {
        this.setMaxRetries(maxRetries);
        return this;
    }

    public void setPerRetryTimeout(Duration perRetryTimeout) {
        this.perRetryTimeout = perRetryTimeout;
    }

    public Duration getPerRetryTimeout() {
        return this.perRetryTimeout;
    }

    public GrpcRetryPolicy withPerRetryTimeout(Duration perRetryTimeout) {
        this.setPerRetryTimeout(perRetryTimeout);
        return this;
    }

    public List<String> getTcpRetryEvents() {
        return this.tcpRetryEvents;
    }

    public void setTcpRetryEvents(Collection<String> tcpRetryEvents) {
        if (tcpRetryEvents == null) {
            this.tcpRetryEvents = null;
            return;
        }
        this.tcpRetryEvents = new ArrayList<String>(tcpRetryEvents);
    }

    public GrpcRetryPolicy withTcpRetryEvents(String ... tcpRetryEvents) {
        if (this.tcpRetryEvents == null) {
            this.setTcpRetryEvents(new ArrayList<String>(tcpRetryEvents.length));
        }
        for (String ele : tcpRetryEvents) {
            this.tcpRetryEvents.add(ele);
        }
        return this;
    }

    public GrpcRetryPolicy withTcpRetryEvents(Collection<String> tcpRetryEvents) {
        this.setTcpRetryEvents(tcpRetryEvents);
        return this;
    }

    public GrpcRetryPolicy withTcpRetryEvents(TcpRetryPolicyEvent ... tcpRetryEvents) {
        ArrayList<String> tcpRetryEventsCopy = new ArrayList<String>(tcpRetryEvents.length);
        for (TcpRetryPolicyEvent value : tcpRetryEvents) {
            tcpRetryEventsCopy.add(value.toString());
        }
        if (this.getTcpRetryEvents() == null) {
            this.setTcpRetryEvents(tcpRetryEventsCopy);
        } else {
            this.getTcpRetryEvents().addAll(tcpRetryEventsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGrpcRetryEvents() != null) {
            sb.append("GrpcRetryEvents: ").append(this.getGrpcRetryEvents()).append(",");
        }
        if (this.getHttpRetryEvents() != null) {
            sb.append("HttpRetryEvents: ").append(this.getHttpRetryEvents()).append(",");
        }
        if (this.getMaxRetries() != null) {
            sb.append("MaxRetries: ").append(this.getMaxRetries()).append(",");
        }
        if (this.getPerRetryTimeout() != null) {
            sb.append("PerRetryTimeout: ").append(this.getPerRetryTimeout()).append(",");
        }
        if (this.getTcpRetryEvents() != null) {
            sb.append("TcpRetryEvents: ").append(this.getTcpRetryEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcRetryPolicy)) {
            return false;
        }
        GrpcRetryPolicy other = (GrpcRetryPolicy)obj;
        if (other.getGrpcRetryEvents() == null ^ this.getGrpcRetryEvents() == null) {
            return false;
        }
        if (other.getGrpcRetryEvents() != null && !other.getGrpcRetryEvents().equals(this.getGrpcRetryEvents())) {
            return false;
        }
        if (other.getHttpRetryEvents() == null ^ this.getHttpRetryEvents() == null) {
            return false;
        }
        if (other.getHttpRetryEvents() != null && !other.getHttpRetryEvents().equals(this.getHttpRetryEvents())) {
            return false;
        }
        if (other.getMaxRetries() == null ^ this.getMaxRetries() == null) {
            return false;
        }
        if (other.getMaxRetries() != null && !other.getMaxRetries().equals(this.getMaxRetries())) {
            return false;
        }
        if (other.getPerRetryTimeout() == null ^ this.getPerRetryTimeout() == null) {
            return false;
        }
        if (other.getPerRetryTimeout() != null && !other.getPerRetryTimeout().equals(this.getPerRetryTimeout())) {
            return false;
        }
        if (other.getTcpRetryEvents() == null ^ this.getTcpRetryEvents() == null) {
            return false;
        }
        return other.getTcpRetryEvents() == null || other.getTcpRetryEvents().equals(this.getTcpRetryEvents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGrpcRetryEvents() == null ? 0 : this.getGrpcRetryEvents().hashCode());
        hashCode = 31 * hashCode + (this.getHttpRetryEvents() == null ? 0 : this.getHttpRetryEvents().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRetries() == null ? 0 : this.getMaxRetries().hashCode());
        hashCode = 31 * hashCode + (this.getPerRetryTimeout() == null ? 0 : this.getPerRetryTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getTcpRetryEvents() == null ? 0 : this.getTcpRetryEvents().hashCode());
        return hashCode;
    }

    public GrpcRetryPolicy clone() {
        try {
            return (GrpcRetryPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GrpcRetryPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

