/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationinsights.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.applicationinsights.model.Problem;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class ProblemMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<String> INSIGHTS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Insights").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> AFFECTEDRESOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AffectedResource").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> SEVERITYLEVEL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SeverityLevel").build();
    private static final MarshallingInfo<String> RESOURCEGROUPNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceGroupName").build();
    private static final MarshallingInfo<Map> FEEDBACK_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Feedback").build();
    private static final ProblemMarshaller instance = new ProblemMarshaller();

    public static ProblemMarshaller getInstance() {
        return instance;
    }

    public void marshall(Problem problem, ProtocolMarshaller protocolMarshaller) {
        if (problem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(problem.getId(), ID_BINDING);
            protocolMarshaller.marshall(problem.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall(problem.getInsights(), INSIGHTS_BINDING);
            protocolMarshaller.marshall(problem.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(problem.getAffectedResource(), AFFECTEDRESOURCE_BINDING);
            protocolMarshaller.marshall(problem.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(problem.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(problem.getSeverityLevel(), SEVERITYLEVEL_BINDING);
            protocolMarshaller.marshall(problem.getResourceGroupName(), RESOURCEGROUPNAME_BINDING);
            protocolMarshaller.marshall(problem.getFeedback(), FEEDBACK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

