/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigatewaymanagementapi;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.apigatewaymanagementapi.AmazonApiGatewayManagementApiAsync;
import com.amazonaws.services.apigatewaymanagementapi.AmazonApiGatewayManagementApiAsyncClientBuilder;
import com.amazonaws.services.apigatewaymanagementapi.AmazonApiGatewayManagementApiClient;
import com.amazonaws.services.apigatewaymanagementapi.model.DeleteConnectionRequest;
import com.amazonaws.services.apigatewaymanagementapi.model.DeleteConnectionResult;
import com.amazonaws.services.apigatewaymanagementapi.model.GetConnectionRequest;
import com.amazonaws.services.apigatewaymanagementapi.model.GetConnectionResult;
import com.amazonaws.services.apigatewaymanagementapi.model.PostToConnectionRequest;
import com.amazonaws.services.apigatewaymanagementapi.model.PostToConnectionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonApiGatewayManagementApiAsyncClient
extends AmazonApiGatewayManagementApiClient
implements AmazonApiGatewayManagementApiAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonApiGatewayManagementApiAsyncClientBuilder asyncBuilder() {
        return AmazonApiGatewayManagementApiAsyncClientBuilder.standard();
    }

    AmazonApiGatewayManagementApiAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(DeleteConnectionRequest request) {
        return this.deleteConnectionAsync(request, null);
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(DeleteConnectionRequest request, final AsyncHandler<DeleteConnectionRequest, DeleteConnectionResult> asyncHandler) {
        final DeleteConnectionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConnectionResult>(){

            @Override
            public DeleteConnectionResult call() throws Exception {
                DeleteConnectionResult result = null;
                try {
                    result = AmazonApiGatewayManagementApiAsyncClient.this.executeDeleteConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetConnectionResult> getConnectionAsync(GetConnectionRequest request) {
        return this.getConnectionAsync(request, null);
    }

    @Override
    public Future<GetConnectionResult> getConnectionAsync(GetConnectionRequest request, final AsyncHandler<GetConnectionRequest, GetConnectionResult> asyncHandler) {
        final GetConnectionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetConnectionResult>(){

            @Override
            public GetConnectionResult call() throws Exception {
                GetConnectionResult result = null;
                try {
                    result = AmazonApiGatewayManagementApiAsyncClient.this.executeGetConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PostToConnectionResult> postToConnectionAsync(PostToConnectionRequest request) {
        return this.postToConnectionAsync(request, null);
    }

    @Override
    public Future<PostToConnectionResult> postToConnectionAsync(PostToConnectionRequest request, final AsyncHandler<PostToConnectionRequest, PostToConnectionResult> asyncHandler) {
        final PostToConnectionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PostToConnectionResult>(){

            @Override
            public PostToConnectionResult call() throws Exception {
                PostToConnectionResult result = null;
                try {
                    result = AmazonApiGatewayManagementApiAsyncClient.this.executePostToConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

