/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.sagemaker.model.DescribeTrainingJobResult;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import java.io.IOException;

@SdkInternalApi
class TrainingJob_Created {
    TrainingJob_Created() {
    }

    static class IsThrottlingExceptionMatcher
    extends WaiterAcceptor<DescribeTrainingJobResult> {
        IsThrottlingExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ThrottlingException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsValidationExceptionMatcher
    extends WaiterAcceptor<DescribeTrainingJobResult> {
        IsValidationExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ValidationException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsDeletingMatcher
    extends WaiterAcceptor<DescribeTrainingJobResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsDeletingMatcher() {
        }

        @Override
        public boolean matches(DescribeTrainingJobResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Deleting\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("TrainingJobStatus");
        }
    }

    static class IsStoppedMatcher
    extends WaiterAcceptor<DescribeTrainingJobResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsStoppedMatcher() {
        }

        @Override
        public boolean matches(DescribeTrainingJobResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Stopped\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("TrainingJobStatus");
        }
    }

    static class IsStoppingMatcher
    extends WaiterAcceptor<DescribeTrainingJobResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsStoppingMatcher() {
        }

        @Override
        public boolean matches(DescribeTrainingJobResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Stopping\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("TrainingJobStatus");
        }
    }

    static class IsFailedMatcher
    extends WaiterAcceptor<DescribeTrainingJobResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFailedMatcher() {
        }

        @Override
        public boolean matches(DescribeTrainingJobResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Failed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("TrainingJobStatus");
        }
    }

    static class IsInProgressMatcher
    extends WaiterAcceptor<DescribeTrainingJobResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsInProgressMatcher() {
        }

        @Override
        public boolean matches(DescribeTrainingJobResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"InProgress\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("TrainingJobStatus");
        }
    }

    static class IsCompletedMatcher
    extends WaiterAcceptor<DescribeTrainingJobResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCompletedMatcher() {
        }

        @Override
        public boolean matches(DescribeTrainingJobResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Completed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("TrainingJobStatus");
        }
    }

    static class IsCreatedMatcher
    extends WaiterAcceptor<DescribeTrainingJobResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCreatedMatcher() {
        }

        @Override
        public boolean matches(DescribeTrainingJobResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Created\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("TrainingJobStatus");
        }
    }
}

