/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.sagemaker.model.DescribeNotebookInstanceResult;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import java.io.IOException;

@SdkInternalApi
class NotebookInstance_Running {
    NotebookInstance_Running() {
    }

    static class IsStoppingMatcher
    extends WaiterAcceptor<DescribeNotebookInstanceResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsStoppingMatcher() {
        }

        @Override
        public boolean matches(DescribeNotebookInstanceResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Stopping\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("NotebookInstanceStatus");
        }
    }

    static class IsStoppedMatcher
    extends WaiterAcceptor<DescribeNotebookInstanceResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsStoppedMatcher() {
        }

        @Override
        public boolean matches(DescribeNotebookInstanceResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Stopped\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("NotebookInstanceStatus");
        }
    }

    static class IsFailedMatcher
    extends WaiterAcceptor<DescribeNotebookInstanceResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFailedMatcher() {
        }

        @Override
        public boolean matches(DescribeNotebookInstanceResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Failed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("NotebookInstanceStatus");
        }
    }

    static class IsThrottlingExceptionMatcher
    extends WaiterAcceptor<DescribeNotebookInstanceResult> {
        IsThrottlingExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ThrottlingException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsInServiceMatcher
    extends WaiterAcceptor<DescribeNotebookInstanceResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsInServiceMatcher() {
        }

        @Override
        public boolean matches(DescribeNotebookInstanceResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"InService\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("NotebookInstanceStatus");
        }
    }
}

