/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroups;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.resourcegroups.AWSResourceGroupsAsync;
import com.amazonaws.services.resourcegroups.AWSResourceGroupsAsyncClientBuilder;
import com.amazonaws.services.resourcegroups.AWSResourceGroupsClient;
import com.amazonaws.services.resourcegroups.model.CreateGroupRequest;
import com.amazonaws.services.resourcegroups.model.CreateGroupResult;
import com.amazonaws.services.resourcegroups.model.DeleteGroupRequest;
import com.amazonaws.services.resourcegroups.model.DeleteGroupResult;
import com.amazonaws.services.resourcegroups.model.GetGroupQueryRequest;
import com.amazonaws.services.resourcegroups.model.GetGroupQueryResult;
import com.amazonaws.services.resourcegroups.model.GetGroupRequest;
import com.amazonaws.services.resourcegroups.model.GetGroupResult;
import com.amazonaws.services.resourcegroups.model.GetTagsRequest;
import com.amazonaws.services.resourcegroups.model.GetTagsResult;
import com.amazonaws.services.resourcegroups.model.ListGroupResourcesRequest;
import com.amazonaws.services.resourcegroups.model.ListGroupResourcesResult;
import com.amazonaws.services.resourcegroups.model.ListGroupsRequest;
import com.amazonaws.services.resourcegroups.model.ListGroupsResult;
import com.amazonaws.services.resourcegroups.model.SearchResourcesRequest;
import com.amazonaws.services.resourcegroups.model.SearchResourcesResult;
import com.amazonaws.services.resourcegroups.model.TagRequest;
import com.amazonaws.services.resourcegroups.model.TagResult;
import com.amazonaws.services.resourcegroups.model.UntagRequest;
import com.amazonaws.services.resourcegroups.model.UntagResult;
import com.amazonaws.services.resourcegroups.model.UpdateGroupQueryRequest;
import com.amazonaws.services.resourcegroups.model.UpdateGroupQueryResult;
import com.amazonaws.services.resourcegroups.model.UpdateGroupRequest;
import com.amazonaws.services.resourcegroups.model.UpdateGroupResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSResourceGroupsAsyncClient
extends AWSResourceGroupsClient
implements AWSResourceGroupsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSResourceGroupsAsyncClientBuilder asyncBuilder() {
        return AWSResourceGroupsAsyncClientBuilder.standard();
    }

    AWSResourceGroupsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request) {
        return this.createGroupAsync(request, null);
    }

    @Override
    public Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request, final AsyncHandler<CreateGroupRequest, CreateGroupResult> asyncHandler) {
        final CreateGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGroupResult>(){

            @Override
            public CreateGroupResult call() throws Exception {
                CreateGroupResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeCreateGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request) {
        return this.deleteGroupAsync(request, null);
    }

    @Override
    public Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request, final AsyncHandler<DeleteGroupRequest, DeleteGroupResult> asyncHandler) {
        final DeleteGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGroupResult>(){

            @Override
            public DeleteGroupResult call() throws Exception {
                DeleteGroupResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeDeleteGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGroupResult> getGroupAsync(GetGroupRequest request) {
        return this.getGroupAsync(request, null);
    }

    @Override
    public Future<GetGroupResult> getGroupAsync(GetGroupRequest request, final AsyncHandler<GetGroupRequest, GetGroupResult> asyncHandler) {
        final GetGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGroupResult>(){

            @Override
            public GetGroupResult call() throws Exception {
                GetGroupResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeGetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGroupQueryResult> getGroupQueryAsync(GetGroupQueryRequest request) {
        return this.getGroupQueryAsync(request, null);
    }

    @Override
    public Future<GetGroupQueryResult> getGroupQueryAsync(GetGroupQueryRequest request, final AsyncHandler<GetGroupQueryRequest, GetGroupQueryResult> asyncHandler) {
        final GetGroupQueryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGroupQueryResult>(){

            @Override
            public GetGroupQueryResult call() throws Exception {
                GetGroupQueryResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeGetGroupQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTagsResult> getTagsAsync(GetTagsRequest request) {
        return this.getTagsAsync(request, null);
    }

    @Override
    public Future<GetTagsResult> getTagsAsync(GetTagsRequest request, final AsyncHandler<GetTagsRequest, GetTagsResult> asyncHandler) {
        final GetTagsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTagsResult>(){

            @Override
            public GetTagsResult call() throws Exception {
                GetTagsResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeGetTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGroupResourcesResult> listGroupResourcesAsync(ListGroupResourcesRequest request) {
        return this.listGroupResourcesAsync(request, null);
    }

    @Override
    public Future<ListGroupResourcesResult> listGroupResourcesAsync(ListGroupResourcesRequest request, final AsyncHandler<ListGroupResourcesRequest, ListGroupResourcesResult> asyncHandler) {
        final ListGroupResourcesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGroupResourcesResult>(){

            @Override
            public ListGroupResourcesResult call() throws Exception {
                ListGroupResourcesResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeListGroupResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request) {
        return this.listGroupsAsync(request, null);
    }

    @Override
    public Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request, final AsyncHandler<ListGroupsRequest, ListGroupsResult> asyncHandler) {
        final ListGroupsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGroupsResult>(){

            @Override
            public ListGroupsResult call() throws Exception {
                ListGroupsResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeListGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchResourcesResult> searchResourcesAsync(SearchResourcesRequest request) {
        return this.searchResourcesAsync(request, null);
    }

    @Override
    public Future<SearchResourcesResult> searchResourcesAsync(SearchResourcesRequest request, final AsyncHandler<SearchResourcesRequest, SearchResourcesResult> asyncHandler) {
        final SearchResourcesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchResourcesResult>(){

            @Override
            public SearchResourcesResult call() throws Exception {
                SearchResourcesResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeSearchResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResult> tagAsync(TagRequest request) {
        return this.tagAsync(request, null);
    }

    @Override
    public Future<TagResult> tagAsync(TagRequest request, final AsyncHandler<TagRequest, TagResult> asyncHandler) {
        final TagRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResult>(){

            @Override
            public TagResult call() throws Exception {
                TagResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeTag(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResult> untagAsync(UntagRequest request) {
        return this.untagAsync(request, null);
    }

    @Override
    public Future<UntagResult> untagAsync(UntagRequest request, final AsyncHandler<UntagRequest, UntagResult> asyncHandler) {
        final UntagRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResult>(){

            @Override
            public UntagResult call() throws Exception {
                UntagResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeUntag(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGroupResult> updateGroupAsync(UpdateGroupRequest request) {
        return this.updateGroupAsync(request, null);
    }

    @Override
    public Future<UpdateGroupResult> updateGroupAsync(UpdateGroupRequest request, final AsyncHandler<UpdateGroupRequest, UpdateGroupResult> asyncHandler) {
        final UpdateGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGroupResult>(){

            @Override
            public UpdateGroupResult call() throws Exception {
                UpdateGroupResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeUpdateGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGroupQueryResult> updateGroupQueryAsync(UpdateGroupQueryRequest request) {
        return this.updateGroupQueryAsync(request, null);
    }

    @Override
    public Future<UpdateGroupQueryResult> updateGroupQueryAsync(UpdateGroupQueryRequest request, final AsyncHandler<UpdateGroupQueryRequest, UpdateGroupQueryResult> asyncHandler) {
        final UpdateGroupQueryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGroupQueryResult>(){

            @Override
            public UpdateGroupQueryResult call() throws Exception {
                UpdateGroupQueryResult result = null;
                try {
                    result = AWSResourceGroupsAsyncClient.this.executeUpdateGroupQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

