/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.ColorSpace;
import com.amazonaws.services.mediaconvert.model.ColorSpaceUsage;
import com.amazonaws.services.mediaconvert.model.Hdr10Metadata;
import com.amazonaws.services.mediaconvert.model.transform.VideoSelectorMarshaller;
import java.io.Serializable;

public class VideoSelector
implements Serializable,
Cloneable,
StructuredPojo {
    private String colorSpace;
    private String colorSpaceUsage;
    private Hdr10Metadata hdr10Metadata;
    private Integer pid;
    private Integer programNumber;

    public void setColorSpace(String colorSpace) {
        this.colorSpace = colorSpace;
    }

    public String getColorSpace() {
        return this.colorSpace;
    }

    public VideoSelector withColorSpace(String colorSpace) {
        this.setColorSpace(colorSpace);
        return this;
    }

    public VideoSelector withColorSpace(ColorSpace colorSpace) {
        this.colorSpace = colorSpace.toString();
        return this;
    }

    public void setColorSpaceUsage(String colorSpaceUsage) {
        this.colorSpaceUsage = colorSpaceUsage;
    }

    public String getColorSpaceUsage() {
        return this.colorSpaceUsage;
    }

    public VideoSelector withColorSpaceUsage(String colorSpaceUsage) {
        this.setColorSpaceUsage(colorSpaceUsage);
        return this;
    }

    public VideoSelector withColorSpaceUsage(ColorSpaceUsage colorSpaceUsage) {
        this.colorSpaceUsage = colorSpaceUsage.toString();
        return this;
    }

    public void setHdr10Metadata(Hdr10Metadata hdr10Metadata) {
        this.hdr10Metadata = hdr10Metadata;
    }

    public Hdr10Metadata getHdr10Metadata() {
        return this.hdr10Metadata;
    }

    public VideoSelector withHdr10Metadata(Hdr10Metadata hdr10Metadata) {
        this.setHdr10Metadata(hdr10Metadata);
        return this;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
    }

    public Integer getPid() {
        return this.pid;
    }

    public VideoSelector withPid(Integer pid) {
        this.setPid(pid);
        return this;
    }

    public void setProgramNumber(Integer programNumber) {
        this.programNumber = programNumber;
    }

    public Integer getProgramNumber() {
        return this.programNumber;
    }

    public VideoSelector withProgramNumber(Integer programNumber) {
        this.setProgramNumber(programNumber);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColorSpace() != null) {
            sb.append("ColorSpace: ").append(this.getColorSpace()).append(",");
        }
        if (this.getColorSpaceUsage() != null) {
            sb.append("ColorSpaceUsage: ").append(this.getColorSpaceUsage()).append(",");
        }
        if (this.getHdr10Metadata() != null) {
            sb.append("Hdr10Metadata: ").append(this.getHdr10Metadata()).append(",");
        }
        if (this.getPid() != null) {
            sb.append("Pid: ").append(this.getPid()).append(",");
        }
        if (this.getProgramNumber() != null) {
            sb.append("ProgramNumber: ").append(this.getProgramNumber());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelector)) {
            return false;
        }
        VideoSelector other = (VideoSelector)obj;
        if (other.getColorSpace() == null ^ this.getColorSpace() == null) {
            return false;
        }
        if (other.getColorSpace() != null && !other.getColorSpace().equals(this.getColorSpace())) {
            return false;
        }
        if (other.getColorSpaceUsage() == null ^ this.getColorSpaceUsage() == null) {
            return false;
        }
        if (other.getColorSpaceUsage() != null && !other.getColorSpaceUsage().equals(this.getColorSpaceUsage())) {
            return false;
        }
        if (other.getHdr10Metadata() == null ^ this.getHdr10Metadata() == null) {
            return false;
        }
        if (other.getHdr10Metadata() != null && !other.getHdr10Metadata().equals(this.getHdr10Metadata())) {
            return false;
        }
        if (other.getPid() == null ^ this.getPid() == null) {
            return false;
        }
        if (other.getPid() != null && !other.getPid().equals(this.getPid())) {
            return false;
        }
        if (other.getProgramNumber() == null ^ this.getProgramNumber() == null) {
            return false;
        }
        return other.getProgramNumber() == null || other.getProgramNumber().equals(this.getProgramNumber());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColorSpace() == null ? 0 : this.getColorSpace().hashCode());
        hashCode = 31 * hashCode + (this.getColorSpaceUsage() == null ? 0 : this.getColorSpaceUsage().hashCode());
        hashCode = 31 * hashCode + (this.getHdr10Metadata() == null ? 0 : this.getHdr10Metadata().hashCode());
        hashCode = 31 * hashCode + (this.getPid() == null ? 0 : this.getPid().hashCode());
        hashCode = 31 * hashCode + (this.getProgramNumber() == null ? 0 : this.getProgramNumber().hashCode());
        return hashCode;
    }

    public VideoSelector clone() {
        try {
            return (VideoSelector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VideoSelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

