/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.InstanceHealthSummary;
import com.amazonaws.services.lightsail.model.LoadBalancerProtocol;
import com.amazonaws.services.lightsail.model.LoadBalancerState;
import com.amazonaws.services.lightsail.model.LoadBalancerTlsCertificateSummary;
import com.amazonaws.services.lightsail.model.ResourceLocation;
import com.amazonaws.services.lightsail.model.ResourceType;
import com.amazonaws.services.lightsail.model.transform.LoadBalancerMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancer
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private String supportCode;
    private Date createdAt;
    private ResourceLocation location;
    private String resourceType;
    private String dnsName;
    private String state;
    private String protocol;
    private List<Integer> publicPorts;
    private String healthCheckPath;
    private Integer instancePort;
    private List<InstanceHealthSummary> instanceHealthSummary;
    private List<LoadBalancerTlsCertificateSummary> tlsCertificateSummaries;
    private Map<String, String> configurationOptions;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LoadBalancer withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public LoadBalancer withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setSupportCode(String supportCode) {
        this.supportCode = supportCode;
    }

    public String getSupportCode() {
        return this.supportCode;
    }

    public LoadBalancer withSupportCode(String supportCode) {
        this.setSupportCode(supportCode);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public LoadBalancer withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public LoadBalancer withLocation(ResourceLocation location) {
        this.setLocation(location);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public LoadBalancer withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public LoadBalancer withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setDnsName(String dnsName) {
        this.dnsName = dnsName;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public LoadBalancer withDnsName(String dnsName) {
        this.setDnsName(dnsName);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public LoadBalancer withState(String state) {
        this.setState(state);
        return this;
    }

    public LoadBalancer withState(LoadBalancerState state) {
        this.state = state.toString();
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public LoadBalancer withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public LoadBalancer withProtocol(LoadBalancerProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public List<Integer> getPublicPorts() {
        return this.publicPorts;
    }

    public void setPublicPorts(Collection<Integer> publicPorts) {
        if (publicPorts == null) {
            this.publicPorts = null;
            return;
        }
        this.publicPorts = new ArrayList<Integer>(publicPorts);
    }

    public LoadBalancer withPublicPorts(Integer ... publicPorts) {
        if (this.publicPorts == null) {
            this.setPublicPorts(new ArrayList<Integer>(publicPorts.length));
        }
        for (Integer ele : publicPorts) {
            this.publicPorts.add(ele);
        }
        return this;
    }

    public LoadBalancer withPublicPorts(Collection<Integer> publicPorts) {
        this.setPublicPorts(publicPorts);
        return this;
    }

    public void setHealthCheckPath(String healthCheckPath) {
        this.healthCheckPath = healthCheckPath;
    }

    public String getHealthCheckPath() {
        return this.healthCheckPath;
    }

    public LoadBalancer withHealthCheckPath(String healthCheckPath) {
        this.setHealthCheckPath(healthCheckPath);
        return this;
    }

    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    public Integer getInstancePort() {
        return this.instancePort;
    }

    public LoadBalancer withInstancePort(Integer instancePort) {
        this.setInstancePort(instancePort);
        return this;
    }

    public List<InstanceHealthSummary> getInstanceHealthSummary() {
        return this.instanceHealthSummary;
    }

    public void setInstanceHealthSummary(Collection<InstanceHealthSummary> instanceHealthSummary) {
        if (instanceHealthSummary == null) {
            this.instanceHealthSummary = null;
            return;
        }
        this.instanceHealthSummary = new ArrayList<InstanceHealthSummary>(instanceHealthSummary);
    }

    public LoadBalancer withInstanceHealthSummary(InstanceHealthSummary ... instanceHealthSummary) {
        if (this.instanceHealthSummary == null) {
            this.setInstanceHealthSummary(new ArrayList<InstanceHealthSummary>(instanceHealthSummary.length));
        }
        for (InstanceHealthSummary ele : instanceHealthSummary) {
            this.instanceHealthSummary.add(ele);
        }
        return this;
    }

    public LoadBalancer withInstanceHealthSummary(Collection<InstanceHealthSummary> instanceHealthSummary) {
        this.setInstanceHealthSummary(instanceHealthSummary);
        return this;
    }

    public List<LoadBalancerTlsCertificateSummary> getTlsCertificateSummaries() {
        return this.tlsCertificateSummaries;
    }

    public void setTlsCertificateSummaries(Collection<LoadBalancerTlsCertificateSummary> tlsCertificateSummaries) {
        if (tlsCertificateSummaries == null) {
            this.tlsCertificateSummaries = null;
            return;
        }
        this.tlsCertificateSummaries = new ArrayList<LoadBalancerTlsCertificateSummary>(tlsCertificateSummaries);
    }

    public LoadBalancer withTlsCertificateSummaries(LoadBalancerTlsCertificateSummary ... tlsCertificateSummaries) {
        if (this.tlsCertificateSummaries == null) {
            this.setTlsCertificateSummaries(new ArrayList<LoadBalancerTlsCertificateSummary>(tlsCertificateSummaries.length));
        }
        for (LoadBalancerTlsCertificateSummary ele : tlsCertificateSummaries) {
            this.tlsCertificateSummaries.add(ele);
        }
        return this;
    }

    public LoadBalancer withTlsCertificateSummaries(Collection<LoadBalancerTlsCertificateSummary> tlsCertificateSummaries) {
        this.setTlsCertificateSummaries(tlsCertificateSummaries);
        return this;
    }

    public Map<String, String> getConfigurationOptions() {
        return this.configurationOptions;
    }

    public void setConfigurationOptions(Map<String, String> configurationOptions) {
        this.configurationOptions = configurationOptions;
    }

    public LoadBalancer withConfigurationOptions(Map<String, String> configurationOptions) {
        this.setConfigurationOptions(configurationOptions);
        return this;
    }

    public LoadBalancer addConfigurationOptionsEntry(String key, String value) {
        if (null == this.configurationOptions) {
            this.configurationOptions = new HashMap<String, String>();
        }
        if (this.configurationOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.configurationOptions.put(key, value);
        return this;
    }

    public LoadBalancer clearConfigurationOptionsEntries() {
        this.configurationOptions = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getSupportCode() != null) {
            sb.append("SupportCode: ").append(this.getSupportCode()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getDnsName() != null) {
            sb.append("DnsName: ").append(this.getDnsName()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getPublicPorts() != null) {
            sb.append("PublicPorts: ").append(this.getPublicPorts()).append(",");
        }
        if (this.getHealthCheckPath() != null) {
            sb.append("HealthCheckPath: ").append(this.getHealthCheckPath()).append(",");
        }
        if (this.getInstancePort() != null) {
            sb.append("InstancePort: ").append(this.getInstancePort()).append(",");
        }
        if (this.getInstanceHealthSummary() != null) {
            sb.append("InstanceHealthSummary: ").append(this.getInstanceHealthSummary()).append(",");
        }
        if (this.getTlsCertificateSummaries() != null) {
            sb.append("TlsCertificateSummaries: ").append(this.getTlsCertificateSummaries()).append(",");
        }
        if (this.getConfigurationOptions() != null) {
            sb.append("ConfigurationOptions: ").append(this.getConfigurationOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancer)) {
            return false;
        }
        LoadBalancer other = (LoadBalancer)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getSupportCode() == null ^ this.getSupportCode() == null) {
            return false;
        }
        if (other.getSupportCode() != null && !other.getSupportCode().equals(this.getSupportCode())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getDnsName() == null ^ this.getDnsName() == null) {
            return false;
        }
        if (other.getDnsName() != null && !other.getDnsName().equals(this.getDnsName())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getPublicPorts() == null ^ this.getPublicPorts() == null) {
            return false;
        }
        if (other.getPublicPorts() != null && !other.getPublicPorts().equals(this.getPublicPorts())) {
            return false;
        }
        if (other.getHealthCheckPath() == null ^ this.getHealthCheckPath() == null) {
            return false;
        }
        if (other.getHealthCheckPath() != null && !other.getHealthCheckPath().equals(this.getHealthCheckPath())) {
            return false;
        }
        if (other.getInstancePort() == null ^ this.getInstancePort() == null) {
            return false;
        }
        if (other.getInstancePort() != null && !other.getInstancePort().equals(this.getInstancePort())) {
            return false;
        }
        if (other.getInstanceHealthSummary() == null ^ this.getInstanceHealthSummary() == null) {
            return false;
        }
        if (other.getInstanceHealthSummary() != null && !other.getInstanceHealthSummary().equals(this.getInstanceHealthSummary())) {
            return false;
        }
        if (other.getTlsCertificateSummaries() == null ^ this.getTlsCertificateSummaries() == null) {
            return false;
        }
        if (other.getTlsCertificateSummaries() != null && !other.getTlsCertificateSummaries().equals(this.getTlsCertificateSummaries())) {
            return false;
        }
        if (other.getConfigurationOptions() == null ^ this.getConfigurationOptions() == null) {
            return false;
        }
        return other.getConfigurationOptions() == null || other.getConfigurationOptions().equals(this.getConfigurationOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getSupportCode() == null ? 0 : this.getSupportCode().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getDnsName() == null ? 0 : this.getDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getPublicPorts() == null ? 0 : this.getPublicPorts().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckPath() == null ? 0 : this.getHealthCheckPath().hashCode());
        hashCode = 31 * hashCode + (this.getInstancePort() == null ? 0 : this.getInstancePort().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceHealthSummary() == null ? 0 : this.getInstanceHealthSummary().hashCode());
        hashCode = 31 * hashCode + (this.getTlsCertificateSummaries() == null ? 0 : this.getTlsCertificateSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationOptions() == null ? 0 : this.getConfigurationOptions().hashCode());
        return hashCode;
    }

    public LoadBalancer clone() {
        try {
            return (LoadBalancer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoadBalancerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

