/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.internal.netty.handler;

import com.amazonaws.services.kinesisvideo.internal.netty.handler.FinalAckEvent;
import com.amazonaws.services.kinesisvideo.model.AckEvent;
import com.amazonaws.services.kinesisvideo.model.transform.AckEventUnmarshaller;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.util.json.Jackson;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.List;

public class PutMediaDecoder
extends MessageToMessageDecoder<HttpObject> {
    private static final AckEventUnmarshaller UNMARSHALLER = new AckEventUnmarshaller();
    private static final byte NEW_LINE = 10;
    private final ByteToMessageDecoder.Cumulator cumulator;
    private ByteBuf cumulation = Unpooled.EMPTY_BUFFER;
    private boolean isSuccessResponse;

    public PutMediaDecoder() {
        this.cumulator = ByteToMessageDecoder.MERGE_CUMULATOR;
    }

    private static void decodeAckEvent(ByteBuf in, List<Object> decodedOut) throws IOException {
        int writerIndex = in.writerIndex();
        for (int readerIndex = in.readerIndex(); readerIndex < writerIndex; ++readerIndex) {
            byte c = in.getByte(readerIndex);
            if (10 != c) continue;
            ByteBuf json = PutMediaDecoder.extractObject(in, in.readerIndex(), readerIndex - in.readerIndex());
            if (json != null) {
                decodedOut.add(PutMediaDecoder.unmarshall(json));
            }
            in.readerIndex(readerIndex + 1);
            in.discardReadBytes();
            readerIndex = in.readerIndex();
            writerIndex = in.writerIndex();
        }
    }

    private static AckEvent unmarshall(ByteBuf json) throws IOException {
        JsonNode jsonNode = Jackson.getObjectMapper().readTree(json.toString(CharsetUtil.UTF_8));
        return UNMARSHALLER.unmarshall(jsonNode);
    }

    private static ByteBuf extractObject(ByteBuf buffer, int index, int length) {
        return buffer.retainedSlice(index, length);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> decodedOut) throws Exception {
        if (httpObject instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)httpObject;
            boolean bl = this.isSuccessResponse = response.status().equals((Object)HttpResponseStatus.OK) && HttpUtil.isTransferEncodingChunked((HttpMessage)response);
        }
        if (httpObject instanceof HttpContent && this.isSuccessResponse) {
            ByteBuf data = ((HttpContent)httpObject).content();
            data.retain();
            this.cumulation = this.cumulator.cumulate(channelHandlerContext.alloc(), this.cumulation, data);
            try {
                PutMediaDecoder.decodeAckEvent(this.cumulation, decodedOut);
            }
            catch (IOException e) {
                channelHandlerContext.fireExceptionCaught((Throwable)e);
            }
            if (httpObject instanceof LastHttpContent) {
                decodedOut.add(new FinalAckEvent());
            }
        }
        if (!this.isSuccessResponse) {
            ReferenceCountUtil.retain((Object)httpObject);
            channelHandlerContext.fireChannelRead((Object)httpObject);
        }
    }
}

