/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appsync.model.ApiKey;

@SdkInternalApi
public class ApiKeyMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Long> EXPIRES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expires").build();
    private static final ApiKeyMarshaller instance = new ApiKeyMarshaller();

    public static ApiKeyMarshaller getInstance() {
        return instance;
    }

    public void marshall(ApiKey apiKey, ProtocolMarshaller protocolMarshaller) {
        if (apiKey == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(apiKey.getId(), ID_BINDING);
            protocolMarshaller.marshall(apiKey.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(apiKey.getExpires(), EXPIRES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

