/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.services.lightsail.model.Bundle;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;

public class BundleJsonUnmarshaller
implements Unmarshaller<Bundle, JsonUnmarshallerContext> {
    private static BundleJsonUnmarshaller instance;

    @Override
    public Bundle unmarshall(JsonUnmarshallerContext context) throws Exception {
        Bundle bundle = new Bundle();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("price", targetDepth)) {
                    context.nextToken();
                    bundle.setPrice(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("cpuCount", targetDepth)) {
                    context.nextToken();
                    bundle.setCpuCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("diskSizeInGb", targetDepth)) {
                    context.nextToken();
                    bundle.setDiskSizeInGb(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("bundleId", targetDepth)) {
                    context.nextToken();
                    bundle.setBundleId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("instanceType", targetDepth)) {
                    context.nextToken();
                    bundle.setInstanceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("isActive", targetDepth)) {
                    context.nextToken();
                    bundle.setIsActive(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    bundle.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("power", targetDepth)) {
                    context.nextToken();
                    bundle.setPower(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ramSizeInGb", targetDepth)) {
                    context.nextToken();
                    bundle.setRamSizeInGb(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("transferPerMonthInGb", targetDepth)) {
                    context.nextToken();
                    bundle.setTransferPerMonthInGb(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("supportedPlatforms", targetDepth)) {
                    context.nextToken();
                    bundle.setSupportedPlatforms(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return bundle;
    }

    public static BundleJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new BundleJsonUnmarshaller();
        }
        return instance;
    }
}

