/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lightsail.model.Blueprint;

@SdkInternalApi
public class BlueprintMarshaller {
    private static final MarshallingInfo<String> BLUEPRINTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blueprintId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> GROUP_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("group").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Boolean> ISACTIVE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isActive").build();
    private static final MarshallingInfo<Integer> MINPOWER_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minPower").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> VERSIONCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versionCode").build();
    private static final MarshallingInfo<String> PRODUCTURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("productUrl").build();
    private static final MarshallingInfo<String> LICENSEURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("licenseUrl").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").build();
    private static final BlueprintMarshaller instance = new BlueprintMarshaller();

    public static BlueprintMarshaller getInstance() {
        return instance;
    }

    public void marshall(Blueprint blueprint, ProtocolMarshaller protocolMarshaller) {
        if (blueprint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(blueprint.getBlueprintId(), BLUEPRINTID_BINDING);
            protocolMarshaller.marshall(blueprint.getName(), NAME_BINDING);
            protocolMarshaller.marshall(blueprint.getGroup(), GROUP_BINDING);
            protocolMarshaller.marshall(blueprint.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(blueprint.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(blueprint.getIsActive(), ISACTIVE_BINDING);
            protocolMarshaller.marshall(blueprint.getMinPower(), MINPOWER_BINDING);
            protocolMarshaller.marshall(blueprint.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall(blueprint.getVersionCode(), VERSIONCODE_BINDING);
            protocolMarshaller.marshall(blueprint.getProductUrl(), PRODUCTURL_BINDING);
            protocolMarshaller.marshall(blueprint.getLicenseUrl(), LICENSEURL_BINDING);
            protocolMarshaller.marshall(blueprint.getPlatform(), PLATFORM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

