/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AddTagsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String pipelineId;
    private SdkInternalList<Tag> tags;

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public AddTagsRequest withPipelineId(String pipelineId) {
        this.setPipelineId(pipelineId);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public AddTagsRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public AddTagsRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: ").append(this.getPipelineId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsRequest)) {
            return false;
        }
        AddTagsRequest other = (AddTagsRequest)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public AddTagsRequest clone() {
        return (AddTagsRequest)super.clone();
    }
}

