/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class StorageDescriptorMarshaller {
    private static final MarshallingInfo<List> COLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Columns").build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Location").build();
    private static final MarshallingInfo<String> INPUTFORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputFormat").build();
    private static final MarshallingInfo<String> OUTPUTFORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputFormat").build();
    private static final MarshallingInfo<Boolean> COMPRESSED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Compressed").build();
    private static final MarshallingInfo<Integer> NUMBEROFBUCKETS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfBuckets").build();
    private static final MarshallingInfo<StructuredPojo> SERDEINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SerdeInfo").build();
    private static final MarshallingInfo<List> BUCKETCOLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketColumns").build();
    private static final MarshallingInfo<List> SORTCOLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortColumns").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<StructuredPojo> SKEWEDINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkewedInfo").build();
    private static final MarshallingInfo<Boolean> STOREDASSUBDIRECTORIES_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StoredAsSubDirectories").build();
    private static final StorageDescriptorMarshaller instance = new StorageDescriptorMarshaller();

    public static StorageDescriptorMarshaller getInstance() {
        return instance;
    }

    public void marshall(StorageDescriptor storageDescriptor, ProtocolMarshaller protocolMarshaller) {
        if (storageDescriptor == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(storageDescriptor.getColumns(), COLUMNS_BINDING);
            protocolMarshaller.marshall(storageDescriptor.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall(storageDescriptor.getInputFormat(), INPUTFORMAT_BINDING);
            protocolMarshaller.marshall(storageDescriptor.getOutputFormat(), OUTPUTFORMAT_BINDING);
            protocolMarshaller.marshall(storageDescriptor.getCompressed(), COMPRESSED_BINDING);
            protocolMarshaller.marshall(storageDescriptor.getNumberOfBuckets(), NUMBEROFBUCKETS_BINDING);
            protocolMarshaller.marshall(storageDescriptor.getSerdeInfo(), SERDEINFO_BINDING);
            protocolMarshaller.marshall(storageDescriptor.getBucketColumns(), BUCKETCOLUMNS_BINDING);
            protocolMarshaller.marshall(storageDescriptor.getSortColumns(), SORTCOLUMNS_BINDING);
            protocolMarshaller.marshall(storageDescriptor.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(storageDescriptor.getSkewedInfo(), SKEWEDINFO_BINDING);
            protocolMarshaller.marshall(storageDescriptor.getStoredAsSubDirectories(), STOREDASSUBDIRECTORIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

