/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.OperatingSystem;
import com.amazonaws.services.simplesystemsmanagement.model.PatchComplianceLevel;
import com.amazonaws.services.simplesystemsmanagement.model.PatchFilterGroup;
import com.amazonaws.services.simplesystemsmanagement.model.PatchRuleGroup;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class UpdatePatchBaselineResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String baselineId;
    private String name;
    private String operatingSystem;
    private PatchFilterGroup globalFilters;
    private PatchRuleGroup approvalRules;
    private SdkInternalList<String> approvedPatches;
    private String approvedPatchesComplianceLevel;
    private SdkInternalList<String> rejectedPatches;
    private Date createdDate;
    private Date modifiedDate;
    private String description;

    public void setBaselineId(String baselineId) {
        this.baselineId = baselineId;
    }

    public String getBaselineId() {
        return this.baselineId;
    }

    public UpdatePatchBaselineResult withBaselineId(String baselineId) {
        this.setBaselineId(baselineId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdatePatchBaselineResult withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    @JsonProperty(value="operatingSystem")
    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public UpdatePatchBaselineResult withOperatingSystem(String operatingSystem) {
        this.setOperatingSystem(operatingSystem);
        return this;
    }

    @JsonIgnore
    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.withOperatingSystem(operatingSystem);
    }

    public UpdatePatchBaselineResult withOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem.toString();
        return this;
    }

    public void setGlobalFilters(PatchFilterGroup globalFilters) {
        this.globalFilters = globalFilters;
    }

    public PatchFilterGroup getGlobalFilters() {
        return this.globalFilters;
    }

    public UpdatePatchBaselineResult withGlobalFilters(PatchFilterGroup globalFilters) {
        this.setGlobalFilters(globalFilters);
        return this;
    }

    public void setApprovalRules(PatchRuleGroup approvalRules) {
        this.approvalRules = approvalRules;
    }

    public PatchRuleGroup getApprovalRules() {
        return this.approvalRules;
    }

    public UpdatePatchBaselineResult withApprovalRules(PatchRuleGroup approvalRules) {
        this.setApprovalRules(approvalRules);
        return this;
    }

    public List<String> getApprovedPatches() {
        if (this.approvedPatches == null) {
            this.approvedPatches = new SdkInternalList();
        }
        return this.approvedPatches;
    }

    public void setApprovedPatches(Collection<String> approvedPatches) {
        if (approvedPatches == null) {
            this.approvedPatches = null;
            return;
        }
        this.approvedPatches = new SdkInternalList<String>(approvedPatches);
    }

    public UpdatePatchBaselineResult withApprovedPatches(String ... approvedPatches) {
        if (this.approvedPatches == null) {
            this.setApprovedPatches(new SdkInternalList<String>(approvedPatches.length));
        }
        for (String ele : approvedPatches) {
            this.approvedPatches.add(ele);
        }
        return this;
    }

    public UpdatePatchBaselineResult withApprovedPatches(Collection<String> approvedPatches) {
        this.setApprovedPatches(approvedPatches);
        return this;
    }

    public void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
        this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
    }

    @JsonProperty(value="approvedPatchesComplianceLevel")
    public String getApprovedPatchesComplianceLevel() {
        return this.approvedPatchesComplianceLevel;
    }

    public UpdatePatchBaselineResult withApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
        this.setApprovedPatchesComplianceLevel(approvedPatchesComplianceLevel);
        return this;
    }

    @JsonIgnore
    public void setApprovedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
        this.withApprovedPatchesComplianceLevel(approvedPatchesComplianceLevel);
    }

    public UpdatePatchBaselineResult withApprovedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
        this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel.toString();
        return this;
    }

    public List<String> getRejectedPatches() {
        if (this.rejectedPatches == null) {
            this.rejectedPatches = new SdkInternalList();
        }
        return this.rejectedPatches;
    }

    public void setRejectedPatches(Collection<String> rejectedPatches) {
        if (rejectedPatches == null) {
            this.rejectedPatches = null;
            return;
        }
        this.rejectedPatches = new SdkInternalList<String>(rejectedPatches);
    }

    public UpdatePatchBaselineResult withRejectedPatches(String ... rejectedPatches) {
        if (this.rejectedPatches == null) {
            this.setRejectedPatches(new SdkInternalList<String>(rejectedPatches.length));
        }
        for (String ele : rejectedPatches) {
            this.rejectedPatches.add(ele);
        }
        return this;
    }

    public UpdatePatchBaselineResult withRejectedPatches(Collection<String> rejectedPatches) {
        this.setRejectedPatches(rejectedPatches);
        return this;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public UpdatePatchBaselineResult withCreatedDate(Date createdDate) {
        this.setCreatedDate(createdDate);
        return this;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public UpdatePatchBaselineResult withModifiedDate(Date modifiedDate) {
        this.setModifiedDate(modifiedDate);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdatePatchBaselineResult withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBaselineId() != null) {
            sb.append("BaselineId: ").append(this.getBaselineId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOperatingSystem() != null) {
            sb.append("OperatingSystem: ").append(this.getOperatingSystem()).append(",");
        }
        if (this.getGlobalFilters() != null) {
            sb.append("GlobalFilters: ").append(this.getGlobalFilters()).append(",");
        }
        if (this.getApprovalRules() != null) {
            sb.append("ApprovalRules: ").append(this.getApprovalRules()).append(",");
        }
        if (this.getApprovedPatches() != null) {
            sb.append("ApprovedPatches: ").append(this.getApprovedPatches()).append(",");
        }
        if (this.getApprovedPatchesComplianceLevel() != null) {
            sb.append("ApprovedPatchesComplianceLevel: ").append(this.getApprovedPatchesComplianceLevel()).append(",");
        }
        if (this.getRejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(this.getRejectedPatches()).append(",");
        }
        if (this.getCreatedDate() != null) {
            sb.append("CreatedDate: ").append(this.getCreatedDate()).append(",");
        }
        if (this.getModifiedDate() != null) {
            sb.append("ModifiedDate: ").append(this.getModifiedDate()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePatchBaselineResult)) {
            return false;
        }
        UpdatePatchBaselineResult other = (UpdatePatchBaselineResult)obj;
        if (other.getBaselineId() == null ^ this.getBaselineId() == null) {
            return false;
        }
        if (other.getBaselineId() != null && !other.getBaselineId().equals(this.getBaselineId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOperatingSystem() == null ^ this.getOperatingSystem() == null) {
            return false;
        }
        if (other.getOperatingSystem() != null && !other.getOperatingSystem().equals(this.getOperatingSystem())) {
            return false;
        }
        if (other.getGlobalFilters() == null ^ this.getGlobalFilters() == null) {
            return false;
        }
        if (other.getGlobalFilters() != null && !other.getGlobalFilters().equals(this.getGlobalFilters())) {
            return false;
        }
        if (other.getApprovalRules() == null ^ this.getApprovalRules() == null) {
            return false;
        }
        if (other.getApprovalRules() != null && !other.getApprovalRules().equals(this.getApprovalRules())) {
            return false;
        }
        if (other.getApprovedPatches() == null ^ this.getApprovedPatches() == null) {
            return false;
        }
        if (other.getApprovedPatches() != null && !other.getApprovedPatches().equals(this.getApprovedPatches())) {
            return false;
        }
        if (other.getApprovedPatchesComplianceLevel() == null ^ this.getApprovedPatchesComplianceLevel() == null) {
            return false;
        }
        if (other.getApprovedPatchesComplianceLevel() != null && !other.getApprovedPatchesComplianceLevel().equals(this.getApprovedPatchesComplianceLevel())) {
            return false;
        }
        if (other.getRejectedPatches() == null ^ this.getRejectedPatches() == null) {
            return false;
        }
        if (other.getRejectedPatches() != null && !other.getRejectedPatches().equals(this.getRejectedPatches())) {
            return false;
        }
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null) {
            return false;
        }
        if (other.getCreatedDate() != null && !other.getCreatedDate().equals(this.getCreatedDate())) {
            return false;
        }
        if (other.getModifiedDate() == null ^ this.getModifiedDate() == null) {
            return false;
        }
        if (other.getModifiedDate() != null && !other.getModifiedDate().equals(this.getModifiedDate())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBaselineId() == null ? 0 : this.getBaselineId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystem() == null ? 0 : this.getOperatingSystem().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalFilters() == null ? 0 : this.getGlobalFilters().hashCode());
        hashCode = 31 * hashCode + (this.getApprovalRules() == null ? 0 : this.getApprovalRules().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatches() == null ? 0 : this.getApprovedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatchesComplianceLevel() == null ? 0 : this.getApprovedPatchesComplianceLevel().hashCode());
        hashCode = 31 * hashCode + (this.getRejectedPatches() == null ? 0 : this.getRejectedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedDate() == null ? 0 : this.getCreatedDate().hashCode());
        hashCode = 31 * hashCode + (this.getModifiedDate() == null ? 0 : this.getModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    public UpdatePatchBaselineResult clone() {
        try {
            return (UpdatePatchBaselineResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

