/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.InstanceProfile;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListInstanceProfilesForRoleResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<InstanceProfile> instanceProfiles;
    private Boolean isTruncated;
    private String marker;

    public List<InstanceProfile> getInstanceProfiles() {
        if (this.instanceProfiles == null) {
            this.instanceProfiles = new SdkInternalList();
        }
        return this.instanceProfiles;
    }

    public void setInstanceProfiles(Collection<InstanceProfile> instanceProfiles) {
        if (instanceProfiles == null) {
            this.instanceProfiles = null;
            return;
        }
        this.instanceProfiles = new SdkInternalList<InstanceProfile>(instanceProfiles);
    }

    public ListInstanceProfilesForRoleResult withInstanceProfiles(InstanceProfile ... instanceProfiles) {
        if (this.instanceProfiles == null) {
            this.setInstanceProfiles(new SdkInternalList<InstanceProfile>(instanceProfiles.length));
        }
        for (InstanceProfile ele : instanceProfiles) {
            this.instanceProfiles.add(ele);
        }
        return this;
    }

    public ListInstanceProfilesForRoleResult withInstanceProfiles(Collection<InstanceProfile> instanceProfiles) {
        this.setInstanceProfiles(instanceProfiles);
        return this;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public ListInstanceProfilesForRoleResult withIsTruncated(Boolean isTruncated) {
        this.setIsTruncated(isTruncated);
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListInstanceProfilesForRoleResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceProfiles() != null) {
            sb.append("InstanceProfiles: ").append(this.getInstanceProfiles()).append(",");
        }
        if (this.getIsTruncated() != null) {
            sb.append("IsTruncated: ").append(this.getIsTruncated()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceProfilesForRoleResult)) {
            return false;
        }
        ListInstanceProfilesForRoleResult other = (ListInstanceProfilesForRoleResult)obj;
        if (other.getInstanceProfiles() == null ^ this.getInstanceProfiles() == null) {
            return false;
        }
        if (other.getInstanceProfiles() != null && !other.getInstanceProfiles().equals(this.getInstanceProfiles())) {
            return false;
        }
        if (other.getIsTruncated() == null ^ this.getIsTruncated() == null) {
            return false;
        }
        if (other.getIsTruncated() != null && !other.getIsTruncated().equals(this.getIsTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceProfiles() == null ? 0 : this.getInstanceProfiles().hashCode());
        hashCode = 31 * hashCode + (this.getIsTruncated() == null ? 0 : this.getIsTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListInstanceProfilesForRoleResult clone() {
        try {
            return (ListInstanceProfilesForRoleResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

