/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devicefarm.model.Device;
import com.amazonaws.services.devicefarm.model.IncompatibilityMessage;
import com.amazonaws.services.devicefarm.model.transform.DevicePoolCompatibilityResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DevicePoolCompatibilityResult
implements Serializable,
Cloneable,
StructuredPojo {
    private Device device;
    private Boolean compatible;
    private List<IncompatibilityMessage> incompatibilityMessages;

    public void setDevice(Device device) {
        this.device = device;
    }

    public Device getDevice() {
        return this.device;
    }

    public DevicePoolCompatibilityResult withDevice(Device device) {
        this.setDevice(device);
        return this;
    }

    public void setCompatible(Boolean compatible) {
        this.compatible = compatible;
    }

    public Boolean getCompatible() {
        return this.compatible;
    }

    public DevicePoolCompatibilityResult withCompatible(Boolean compatible) {
        this.setCompatible(compatible);
        return this;
    }

    public Boolean isCompatible() {
        return this.compatible;
    }

    public List<IncompatibilityMessage> getIncompatibilityMessages() {
        return this.incompatibilityMessages;
    }

    public void setIncompatibilityMessages(Collection<IncompatibilityMessage> incompatibilityMessages) {
        if (incompatibilityMessages == null) {
            this.incompatibilityMessages = null;
            return;
        }
        this.incompatibilityMessages = new ArrayList<IncompatibilityMessage>(incompatibilityMessages);
    }

    public DevicePoolCompatibilityResult withIncompatibilityMessages(IncompatibilityMessage ... incompatibilityMessages) {
        if (this.incompatibilityMessages == null) {
            this.setIncompatibilityMessages(new ArrayList<IncompatibilityMessage>(incompatibilityMessages.length));
        }
        for (IncompatibilityMessage ele : incompatibilityMessages) {
            this.incompatibilityMessages.add(ele);
        }
        return this;
    }

    public DevicePoolCompatibilityResult withIncompatibilityMessages(Collection<IncompatibilityMessage> incompatibilityMessages) {
        this.setIncompatibilityMessages(incompatibilityMessages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDevice() != null) {
            sb.append("Device: ").append(this.getDevice()).append(",");
        }
        if (this.getCompatible() != null) {
            sb.append("Compatible: ").append(this.getCompatible()).append(",");
        }
        if (this.getIncompatibilityMessages() != null) {
            sb.append("IncompatibilityMessages: ").append(this.getIncompatibilityMessages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevicePoolCompatibilityResult)) {
            return false;
        }
        DevicePoolCompatibilityResult other = (DevicePoolCompatibilityResult)obj;
        if (other.getDevice() == null ^ this.getDevice() == null) {
            return false;
        }
        if (other.getDevice() != null && !other.getDevice().equals(this.getDevice())) {
            return false;
        }
        if (other.getCompatible() == null ^ this.getCompatible() == null) {
            return false;
        }
        if (other.getCompatible() != null && !other.getCompatible().equals(this.getCompatible())) {
            return false;
        }
        if (other.getIncompatibilityMessages() == null ^ this.getIncompatibilityMessages() == null) {
            return false;
        }
        return other.getIncompatibilityMessages() == null || other.getIncompatibilityMessages().equals(this.getIncompatibilityMessages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDevice() == null ? 0 : this.getDevice().hashCode());
        hashCode = 31 * hashCode + (this.getCompatible() == null ? 0 : this.getCompatible().hashCode());
        hashCode = 31 * hashCode + (this.getIncompatibilityMessages() == null ? 0 : this.getIncompatibilityMessages().hashCode());
        return hashCode;
    }

    public DevicePoolCompatibilityResult clone() {
        try {
            return (DevicePoolCompatibilityResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DevicePoolCompatibilityResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

