/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codebuild.model.EnvironmentLanguage;
import java.util.List;

@SdkInternalApi
public class EnvironmentLanguageMarshaller {
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("language").build();
    private static final MarshallingInfo<List> IMAGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("images").build();
    private static final EnvironmentLanguageMarshaller instance = new EnvironmentLanguageMarshaller();

    public static EnvironmentLanguageMarshaller getInstance() {
        return instance;
    }

    public void marshall(EnvironmentLanguage environmentLanguage, ProtocolMarshaller protocolMarshaller) {
        if (environmentLanguage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(environmentLanguage.getLanguage(), LANGUAGE_BINDING);
            protocolMarshaller.marshall(environmentLanguage.getImages(), IMAGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

