/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.IpRange;
import com.amazonaws.services.ec2.model.Ipv6Range;
import com.amazonaws.services.ec2.model.PrefixListId;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RevokeSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<RevokeSecurityGroupIngressRequest>, RevokeSecurityGroupIngressRequest> {
    @Override
    public Request<RevokeSecurityGroupIngressRequest> marshall(RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest) {
        SdkInternalList revokeSecurityGroupIngressRequestIpPermissionsList;
        if (revokeSecurityGroupIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RevokeSecurityGroupIngressRequest> request = new DefaultRequest<RevokeSecurityGroupIngressRequest>(revokeSecurityGroupIngressRequest, "AmazonEC2");
        request.addParameter("Action", "RevokeSecurityGroupIngress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeSecurityGroupIngressRequest.getCidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString(revokeSecurityGroupIngressRequest.getCidrIp()));
        }
        if (revokeSecurityGroupIngressRequest.getFromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequest.getFromPort()));
        }
        if (revokeSecurityGroupIngressRequest.getGroupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString(revokeSecurityGroupIngressRequest.getGroupId()));
        }
        if (revokeSecurityGroupIngressRequest.getGroupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(revokeSecurityGroupIngressRequest.getGroupName()));
        }
        if (!(revokeSecurityGroupIngressRequestIpPermissionsList = (SdkInternalList)revokeSecurityGroupIngressRequest.getIpPermissions()).isEmpty() || !revokeSecurityGroupIngressRequestIpPermissionsList.isAutoConstruct()) {
            int ipPermissionsListIndex = 1;
            for (IpPermission revokeSecurityGroupIngressRequestIpPermissionsListValue : revokeSecurityGroupIngressRequestIpPermissionsList) {
                SdkInternalList ipPermissionIpv4RangesList;
                SdkInternalList ipPermissionUserIdGroupPairsList;
                SdkInternalList ipPermissionPrefixListIdsList;
                SdkInternalList ipPermissionIpv6RangesList;
                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.getFromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequestIpPermissionsListValue.getFromPort()));
                }
                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.getIpProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString(revokeSecurityGroupIngressRequestIpPermissionsListValue.getIpProtocol()));
                }
                if (!(ipPermissionIpv6RangesList = (SdkInternalList)revokeSecurityGroupIngressRequestIpPermissionsListValue.getIpv6Ranges()).isEmpty() || !ipPermissionIpv6RangesList.isAutoConstruct()) {
                    int ipv6RangesListIndex = 1;
                    for (Object ipPermissionIpv6RangesListValue : ipPermissionIpv6RangesList) {
                        if (((Ipv6Range)ipPermissionIpv6RangesListValue).getCidrIpv6() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex + ".CidrIpv6", StringUtils.fromString(((Ipv6Range)ipPermissionIpv6RangesListValue).getCidrIpv6()));
                        }
                        ++ipv6RangesListIndex;
                    }
                }
                if (!(ipPermissionPrefixListIdsList = (SdkInternalList)revokeSecurityGroupIngressRequestIpPermissionsListValue.getPrefixListIds()).isEmpty() || !ipPermissionPrefixListIdsList.isAutoConstruct()) {
                    Object ipPermissionIpv6RangesListValue;
                    int prefixListIdsListIndex = 1;
                    ipPermissionIpv6RangesListValue = ipPermissionPrefixListIdsList.iterator();
                    while (ipPermissionIpv6RangesListValue.hasNext()) {
                        PrefixListId ipPermissionPrefixListIdsListValue = (PrefixListId)ipPermissionIpv6RangesListValue.next();
                        if (ipPermissionPrefixListIdsListValue.getPrefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString(ipPermissionPrefixListIdsListValue.getPrefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.getToPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequestIpPermissionsListValue.getToPort()));
                }
                if (!(ipPermissionUserIdGroupPairsList = (SdkInternalList)revokeSecurityGroupIngressRequestIpPermissionsListValue.getUserIdGroupPairs()).isEmpty() || !ipPermissionUserIdGroupPairsList.isAutoConstruct()) {
                    int userIdGroupPairsListIndex = 1;
                    for (UserIdGroupPair ipPermissionUserIdGroupPairsListValue : ipPermissionUserIdGroupPairsList) {
                        if (ipPermissionUserIdGroupPairsListValue.getGroupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.getGroupId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.getGroupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.getGroupName()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.getPeeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.getPeeringStatus()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.getUserId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.getUserId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.getVpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.getVpcId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.getVpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString(ipPermissionUserIdGroupPairsListValue.getVpcPeeringConnectionId()));
                        }
                        ++userIdGroupPairsListIndex;
                    }
                }
                if (!(ipPermissionIpv4RangesList = (SdkInternalList)revokeSecurityGroupIngressRequestIpPermissionsListValue.getIpv4Ranges()).isEmpty() || !ipPermissionIpv4RangesList.isAutoConstruct()) {
                    int ipv4RangesListIndex = 1;
                    for (IpRange ipPermissionIpv4RangesListValue : ipPermissionIpv4RangesList) {
                        if (ipPermissionIpv4RangesListValue.getCidrIp() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex + ".CidrIp", StringUtils.fromString(ipPermissionIpv4RangesListValue.getCidrIp()));
                        }
                        ++ipv4RangesListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        if (revokeSecurityGroupIngressRequest.getIpProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString(revokeSecurityGroupIngressRequest.getIpProtocol()));
        }
        if (revokeSecurityGroupIngressRequest.getSourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString(revokeSecurityGroupIngressRequest.getSourceSecurityGroupName()));
        }
        if (revokeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString(revokeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId()));
        }
        if (revokeSecurityGroupIngressRequest.getToPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequest.getToPort()));
        }
        return request;
    }
}

