/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudsearchv2.model.AnalysisOptions;
import com.amazonaws.services.cloudsearchv2.model.AnalysisScheme;
import com.amazonaws.services.cloudsearchv2.model.DefineAnalysisSchemeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DefineAnalysisSchemeRequestMarshaller
implements Marshaller<Request<DefineAnalysisSchemeRequest>, DefineAnalysisSchemeRequest> {
    @Override
    public Request<DefineAnalysisSchemeRequest> marshall(DefineAnalysisSchemeRequest defineAnalysisSchemeRequest) {
        AnalysisScheme analysisScheme;
        if (defineAnalysisSchemeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DefineAnalysisSchemeRequest> request = new DefaultRequest<DefineAnalysisSchemeRequest>(defineAnalysisSchemeRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineAnalysisScheme");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (defineAnalysisSchemeRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(defineAnalysisSchemeRequest.getDomainName()));
        }
        if ((analysisScheme = defineAnalysisSchemeRequest.getAnalysisScheme()) != null) {
            AnalysisOptions analysisOptions;
            if (analysisScheme.getAnalysisSchemeName() != null) {
                request.addParameter("AnalysisScheme.AnalysisSchemeName", StringUtils.fromString(analysisScheme.getAnalysisSchemeName()));
            }
            if (analysisScheme.getAnalysisSchemeLanguage() != null) {
                request.addParameter("AnalysisScheme.AnalysisSchemeLanguage", StringUtils.fromString(analysisScheme.getAnalysisSchemeLanguage()));
            }
            if ((analysisOptions = analysisScheme.getAnalysisOptions()) != null) {
                if (analysisOptions.getSynonyms() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.Synonyms", StringUtils.fromString(analysisOptions.getSynonyms()));
                }
                if (analysisOptions.getStopwords() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.Stopwords", StringUtils.fromString(analysisOptions.getStopwords()));
                }
                if (analysisOptions.getStemmingDictionary() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.StemmingDictionary", StringUtils.fromString(analysisOptions.getStemmingDictionary()));
                }
                if (analysisOptions.getJapaneseTokenizationDictionary() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.JapaneseTokenizationDictionary", StringUtils.fromString(analysisOptions.getJapaneseTokenizationDictionary()));
                }
                if (analysisOptions.getAlgorithmicStemming() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.AlgorithmicStemming", StringUtils.fromString(analysisOptions.getAlgorithmicStemming()));
                }
            }
        }
        return request;
    }
}

