/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.apache.http.protocol;

import com.amazonaws.thirdparty.apache.http.HttpEntity;
import com.amazonaws.thirdparty.apache.http.HttpEntityEnclosingRequest;
import com.amazonaws.thirdparty.apache.http.HttpException;
import com.amazonaws.thirdparty.apache.http.HttpRequest;
import com.amazonaws.thirdparty.apache.http.HttpRequestInterceptor;
import com.amazonaws.thirdparty.apache.http.HttpVersion;
import com.amazonaws.thirdparty.apache.http.ProtocolVersion;
import com.amazonaws.thirdparty.apache.http.annotation.Immutable;
import com.amazonaws.thirdparty.apache.http.protocol.HttpContext;
import com.amazonaws.thirdparty.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

