/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticmapreduce.model.InstanceFleetProvisioningSpecifications;
import com.amazonaws.services.elasticmapreduce.model.InstanceFleetType;
import com.amazonaws.services.elasticmapreduce.model.InstanceTypeConfig;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceFleetConfigMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceFleetConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String instanceFleetType;
    private Integer targetOnDemandCapacity;
    private Integer targetSpotCapacity;
    private SdkInternalList<InstanceTypeConfig> instanceTypeConfigs;
    private InstanceFleetProvisioningSpecifications launchSpecifications;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public InstanceFleetConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public void setInstanceFleetType(String instanceFleetType) {
        this.instanceFleetType = instanceFleetType;
    }

    public String getInstanceFleetType() {
        return this.instanceFleetType;
    }

    public InstanceFleetConfig withInstanceFleetType(String instanceFleetType) {
        this.setInstanceFleetType(instanceFleetType);
        return this;
    }

    public void setInstanceFleetType(InstanceFleetType instanceFleetType) {
        this.instanceFleetType = instanceFleetType.toString();
    }

    public InstanceFleetConfig withInstanceFleetType(InstanceFleetType instanceFleetType) {
        this.setInstanceFleetType(instanceFleetType);
        return this;
    }

    public void setTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
        this.targetOnDemandCapacity = targetOnDemandCapacity;
    }

    public Integer getTargetOnDemandCapacity() {
        return this.targetOnDemandCapacity;
    }

    public InstanceFleetConfig withTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
        this.setTargetOnDemandCapacity(targetOnDemandCapacity);
        return this;
    }

    public void setTargetSpotCapacity(Integer targetSpotCapacity) {
        this.targetSpotCapacity = targetSpotCapacity;
    }

    public Integer getTargetSpotCapacity() {
        return this.targetSpotCapacity;
    }

    public InstanceFleetConfig withTargetSpotCapacity(Integer targetSpotCapacity) {
        this.setTargetSpotCapacity(targetSpotCapacity);
        return this;
    }

    public List<InstanceTypeConfig> getInstanceTypeConfigs() {
        if (this.instanceTypeConfigs == null) {
            this.instanceTypeConfigs = new SdkInternalList();
        }
        return this.instanceTypeConfigs;
    }

    public void setInstanceTypeConfigs(Collection<InstanceTypeConfig> instanceTypeConfigs) {
        if (instanceTypeConfigs == null) {
            this.instanceTypeConfigs = null;
            return;
        }
        this.instanceTypeConfigs = new SdkInternalList<InstanceTypeConfig>(instanceTypeConfigs);
    }

    public InstanceFleetConfig withInstanceTypeConfigs(InstanceTypeConfig ... instanceTypeConfigs) {
        if (this.instanceTypeConfigs == null) {
            this.setInstanceTypeConfigs(new SdkInternalList<InstanceTypeConfig>(instanceTypeConfigs.length));
        }
        for (InstanceTypeConfig ele : instanceTypeConfigs) {
            this.instanceTypeConfigs.add(ele);
        }
        return this;
    }

    public InstanceFleetConfig withInstanceTypeConfigs(Collection<InstanceTypeConfig> instanceTypeConfigs) {
        this.setInstanceTypeConfigs(instanceTypeConfigs);
        return this;
    }

    public void setLaunchSpecifications(InstanceFleetProvisioningSpecifications launchSpecifications) {
        this.launchSpecifications = launchSpecifications;
    }

    public InstanceFleetProvisioningSpecifications getLaunchSpecifications() {
        return this.launchSpecifications;
    }

    public InstanceFleetConfig withLaunchSpecifications(InstanceFleetProvisioningSpecifications launchSpecifications) {
        this.setLaunchSpecifications(launchSpecifications);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInstanceFleetType() != null) {
            sb.append("InstanceFleetType: ").append(this.getInstanceFleetType()).append(",");
        }
        if (this.getTargetOnDemandCapacity() != null) {
            sb.append("TargetOnDemandCapacity: ").append(this.getTargetOnDemandCapacity()).append(",");
        }
        if (this.getTargetSpotCapacity() != null) {
            sb.append("TargetSpotCapacity: ").append(this.getTargetSpotCapacity()).append(",");
        }
        if (this.getInstanceTypeConfigs() != null) {
            sb.append("InstanceTypeConfigs: ").append(this.getInstanceTypeConfigs()).append(",");
        }
        if (this.getLaunchSpecifications() != null) {
            sb.append("LaunchSpecifications: ").append(this.getLaunchSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetConfig)) {
            return false;
        }
        InstanceFleetConfig other = (InstanceFleetConfig)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInstanceFleetType() == null ^ this.getInstanceFleetType() == null) {
            return false;
        }
        if (other.getInstanceFleetType() != null && !other.getInstanceFleetType().equals(this.getInstanceFleetType())) {
            return false;
        }
        if (other.getTargetOnDemandCapacity() == null ^ this.getTargetOnDemandCapacity() == null) {
            return false;
        }
        if (other.getTargetOnDemandCapacity() != null && !other.getTargetOnDemandCapacity().equals(this.getTargetOnDemandCapacity())) {
            return false;
        }
        if (other.getTargetSpotCapacity() == null ^ this.getTargetSpotCapacity() == null) {
            return false;
        }
        if (other.getTargetSpotCapacity() != null && !other.getTargetSpotCapacity().equals(this.getTargetSpotCapacity())) {
            return false;
        }
        if (other.getInstanceTypeConfigs() == null ^ this.getInstanceTypeConfigs() == null) {
            return false;
        }
        if (other.getInstanceTypeConfigs() != null && !other.getInstanceTypeConfigs().equals(this.getInstanceTypeConfigs())) {
            return false;
        }
        if (other.getLaunchSpecifications() == null ^ this.getLaunchSpecifications() == null) {
            return false;
        }
        return other.getLaunchSpecifications() == null || other.getLaunchSpecifications().equals(this.getLaunchSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceFleetType() == null ? 0 : this.getInstanceFleetType().hashCode());
        hashCode = 31 * hashCode + (this.getTargetOnDemandCapacity() == null ? 0 : this.getTargetOnDemandCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getTargetSpotCapacity() == null ? 0 : this.getTargetSpotCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTypeConfigs() == null ? 0 : this.getInstanceTypeConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchSpecifications() == null ? 0 : this.getLaunchSpecifications().hashCode());
        return hashCode;
    }

    public InstanceFleetConfig clone() {
        try {
            return (InstanceFleetConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceFleetConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

