/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.ComputeType;
import com.amazonaws.services.codebuild.model.EnvironmentType;
import com.amazonaws.services.codebuild.model.EnvironmentVariable;
import com.amazonaws.services.codebuild.model.transform.ProjectEnvironmentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProjectEnvironment
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String image;
    private String computeType;
    private List<EnvironmentVariable> environmentVariables;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ProjectEnvironment withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(EnvironmentType type) {
        this.type = type.toString();
    }

    public ProjectEnvironment withType(EnvironmentType type) {
        this.setType(type);
        return this;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public ProjectEnvironment withImage(String image) {
        this.setImage(image);
        return this;
    }

    public void setComputeType(String computeType) {
        this.computeType = computeType;
    }

    public String getComputeType() {
        return this.computeType;
    }

    public ProjectEnvironment withComputeType(String computeType) {
        this.setComputeType(computeType);
        return this;
    }

    public void setComputeType(ComputeType computeType) {
        this.computeType = computeType.toString();
    }

    public ProjectEnvironment withComputeType(ComputeType computeType) {
        this.setComputeType(computeType);
        return this;
    }

    public List<EnvironmentVariable> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Collection<EnvironmentVariable> environmentVariables) {
        if (environmentVariables == null) {
            this.environmentVariables = null;
            return;
        }
        this.environmentVariables = new ArrayList<EnvironmentVariable>(environmentVariables);
    }

    public ProjectEnvironment withEnvironmentVariables(EnvironmentVariable ... environmentVariables) {
        if (this.environmentVariables == null) {
            this.setEnvironmentVariables(new ArrayList<EnvironmentVariable>(environmentVariables.length));
        }
        for (EnvironmentVariable ele : environmentVariables) {
            this.environmentVariables.add(ele);
        }
        return this;
    }

    public ProjectEnvironment withEnvironmentVariables(Collection<EnvironmentVariable> environmentVariables) {
        this.setEnvironmentVariables(environmentVariables);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getComputeType() != null) {
            sb.append("ComputeType: ").append(this.getComputeType()).append(",");
        }
        if (this.getEnvironmentVariables() != null) {
            sb.append("EnvironmentVariables: ").append(this.getEnvironmentVariables());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectEnvironment)) {
            return false;
        }
        ProjectEnvironment other = (ProjectEnvironment)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getComputeType() == null ^ this.getComputeType() == null) {
            return false;
        }
        if (other.getComputeType() != null && !other.getComputeType().equals(this.getComputeType())) {
            return false;
        }
        if (other.getEnvironmentVariables() == null ^ this.getEnvironmentVariables() == null) {
            return false;
        }
        return other.getEnvironmentVariables() == null || other.getEnvironmentVariables().equals(this.getEnvironmentVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getComputeType() == null ? 0 : this.getComputeType().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentVariables() == null ? 0 : this.getEnvironmentVariables().hashCode());
        return hashCode;
    }

    public ProjectEnvironment clone() {
        try {
            return (ProjectEnvironment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectEnvironmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

