/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.CharacterSet;
import com.amazonaws.services.rds.model.DBEngineVersion;
import com.amazonaws.services.rds.model.Timezone;
import com.amazonaws.services.rds.model.UpgradeTarget;
import com.amazonaws.services.rds.model.transform.CharacterSetStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.TimezoneStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.UpgradeTargetStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class DBEngineVersionStaxUnmarshaller
implements Unmarshaller<DBEngineVersion, StaxUnmarshallerContext> {
    private static DBEngineVersionStaxUnmarshaller instance;

    @Override
    public DBEngineVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBEngineVersion dBEngineVersion = new DBEngineVersion();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dBEngineVersion;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Engine", targetDepth)) {
                    dBEngineVersion.setEngine(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    dBEngineVersion.setEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBParameterGroupFamily", targetDepth)) {
                    dBEngineVersion.setDBParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineDescription", targetDepth)) {
                    dBEngineVersion.setDBEngineDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineVersionDescription", targetDepth)) {
                    dBEngineVersion.setDBEngineVersionDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultCharacterSet", targetDepth)) {
                    dBEngineVersion.setDefaultCharacterSet(CharacterSetStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedCharacterSets", targetDepth)) {
                    dBEngineVersion.withSupportedCharacterSets(new ArrayList<CharacterSet>());
                    continue;
                }
                if (context.testExpression("SupportedCharacterSets/CharacterSet", targetDepth)) {
                    dBEngineVersion.withSupportedCharacterSets(CharacterSetStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ValidUpgradeTarget", targetDepth)) {
                    dBEngineVersion.withValidUpgradeTarget(new ArrayList<UpgradeTarget>());
                    continue;
                }
                if (context.testExpression("ValidUpgradeTarget/UpgradeTarget", targetDepth)) {
                    dBEngineVersion.withValidUpgradeTarget(UpgradeTargetStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedTimezones", targetDepth)) {
                    dBEngineVersion.withSupportedTimezones(new ArrayList<Timezone>());
                    continue;
                }
                if (!context.testExpression("SupportedTimezones/Timezone", targetDepth)) continue;
                dBEngineVersion.withSupportedTimezones(TimezoneStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dBEngineVersion;
    }

    public static DBEngineVersionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DBEngineVersionStaxUnmarshaller();
        }
        return instance;
    }
}

