/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apigateway.model.DocumentationVersion;
import java.util.Date;

@SdkInternalApi
public class DocumentationVersionMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<Date> CREATEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdDate").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final DocumentationVersionMarshaller instance = new DocumentationVersionMarshaller();

    public static DocumentationVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentationVersion documentationVersion, ProtocolMarshaller protocolMarshaller) {
        if (documentationVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(documentationVersion.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall(documentationVersion.getCreatedDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall(documentationVersion.getDescription(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

