/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.importexport.model.ListJobsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListJobsRequestMarshaller
implements Marshaller<Request<ListJobsRequest>, ListJobsRequest> {
    @Override
    public Request<ListJobsRequest> marshall(ListJobsRequest listJobsRequest) {
        if (listJobsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListJobsRequest> request = new DefaultRequest<ListJobsRequest>(listJobsRequest, "AmazonImportExport");
        request.addParameter("Action", "ListJobs");
        request.addParameter("Version", "2010-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listJobsRequest.getMaxJobs() != null) {
            request.addParameter("MaxJobs", StringUtils.fromInteger(listJobsRequest.getMaxJobs()));
        }
        if (listJobsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listJobsRequest.getMarker()));
        }
        if (listJobsRequest.getAPIVersion() != null) {
            request.addParameter("APIVersion", StringUtils.fromString(listJobsRequest.getAPIVersion()));
        }
        return request;
    }
}

