/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.jackson.databind.ser.std;

import com.amazonaws.thirdparty.jackson.core.JsonGenerationException;
import com.amazonaws.thirdparty.jackson.core.JsonGenerator;
import com.amazonaws.thirdparty.jackson.databind.BeanProperty;
import com.amazonaws.thirdparty.jackson.databind.JavaType;
import com.amazonaws.thirdparty.jackson.databind.JsonMappingException;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.thirdparty.jackson.databind.JsonSerializer;
import com.amazonaws.thirdparty.jackson.databind.SerializationFeature;
import com.amazonaws.thirdparty.jackson.databind.SerializerProvider;
import com.amazonaws.thirdparty.jackson.databind.annotation.JacksonStdImpl;
import com.amazonaws.thirdparty.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.amazonaws.thirdparty.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.amazonaws.thirdparty.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.amazonaws.thirdparty.jackson.databind.jsontype.TypeSerializer;
import com.amazonaws.thirdparty.jackson.databind.node.ObjectNode;
import com.amazonaws.thirdparty.jackson.databind.ser.ContainerSerializer;
import com.amazonaws.thirdparty.jackson.databind.ser.std.ArraySerializerBase;
import com.amazonaws.thirdparty.jackson.databind.ser.std.StdSerializer;
import com.amazonaws.thirdparty.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;

public class StdArraySerializers {
    protected static final HashMap<String, JsonSerializer<?>> _arraySerializers = new HashMap();

    protected StdArraySerializers() {
    }

    public static JsonSerializer<?> findStandardImpl(Class<?> cls) {
        return _arraySerializers.get(cls.getName());
    }

    static {
        _arraySerializers.put(boolean[].class.getName(), new BooleanArraySerializer());
        _arraySerializers.put(byte[].class.getName(), new ByteArraySerializer());
        _arraySerializers.put(char[].class.getName(), new CharArraySerializer());
        _arraySerializers.put(short[].class.getName(), new ShortArraySerializer());
        _arraySerializers.put(int[].class.getName(), new IntArraySerializer());
        _arraySerializers.put(long[].class.getName(), new LongArraySerializer());
        _arraySerializers.put(float[].class.getName(), new FloatArraySerializer());
        _arraySerializers.put(double[].class.getName(), new DoubleArraySerializer());
    }

    @JacksonStdImpl
    public static class DoubleArraySerializer
    extends ArraySerializerBase<double[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Double.TYPE);

        public DoubleArraySerializer() {
            super(double[].class);
        }

        protected DoubleArraySerializer(DoubleArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new DoubleArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, double[] value) {
            return value == null || value.length == 0;
        }

        @Override
        public boolean hasSingleElement(double[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(double[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
                this.serializeContents(value, gen, provider);
                return;
            }
            gen.writeStartArray(len);
            this.serializeContents(value, gen, provider);
            gen.writeEndArray();
        }

        @Override
        public void serializeContents(double[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                gen.writeNumber(value[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.NUMBER);
            }
        }
    }

    @JacksonStdImpl
    public static class FloatArraySerializer
    extends TypedPrimitiveArraySerializer<float[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Float.TYPE);

        public FloatArraySerializer() {
            super(float[].class);
        }

        public FloatArraySerializer(FloatArraySerializer src, BeanProperty prop, TypeSerializer vts, Boolean unwrapSingle) {
            super(src, prop, vts, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new FloatArraySerializer(this, this._property, vts, this._unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new FloatArraySerializer(this, prop, this._valueTypeSerializer, unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, float[] value) {
            return value == null || value.length == 0;
        }

        @Override
        public boolean hasSingleElement(float[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(float[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
                this.serializeContents(value, gen, provider);
                return;
            }
            gen.writeStartArray(len);
            this.serializeContents(value, gen, provider);
            gen.writeEndArray();
        }

        @Override
        public void serializeContents(float[] value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (this._valueTypeSerializer != null) {
                int len = value.length;
                for (int i = 0; i < len; ++i) {
                    this._valueTypeSerializer.writeTypePrefixForScalar(null, gen, Float.TYPE);
                    gen.writeNumber(value[i]);
                    this._valueTypeSerializer.writeTypeSuffixForScalar(null, gen);
                }
                return;
            }
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                gen.writeNumber(value[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.NUMBER);
            }
        }
    }

    @JacksonStdImpl
    public static class LongArraySerializer
    extends TypedPrimitiveArraySerializer<long[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Long.TYPE);

        public LongArraySerializer() {
            super(long[].class);
        }

        public LongArraySerializer(LongArraySerializer src, BeanProperty prop, TypeSerializer vts, Boolean unwrapSingle) {
            super(src, prop, vts, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new LongArraySerializer(this, prop, this._valueTypeSerializer, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new LongArraySerializer(this, this._property, vts, this._unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, long[] value) {
            return value == null || value.length == 0;
        }

        @Override
        public boolean hasSingleElement(long[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(long[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
                this.serializeContents(value, jgen, provider);
                return;
            }
            jgen.writeStartArray(len);
            this.serializeContents(value, jgen, provider);
            jgen.writeEndArray();
        }

        @Override
        public void serializeContents(long[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (this._valueTypeSerializer != null) {
                int len = value.length;
                for (int i = 0; i < len; ++i) {
                    this._valueTypeSerializer.writeTypePrefixForScalar(null, jgen, Long.TYPE);
                    jgen.writeNumber(value[i]);
                    this._valueTypeSerializer.writeTypeSuffixForScalar(null, jgen);
                }
                return;
            }
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number", true));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.NUMBER);
            }
        }
    }

    @JacksonStdImpl
    public static class IntArraySerializer
    extends ArraySerializerBase<int[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Integer.TYPE);

        public IntArraySerializer() {
            super(int[].class);
        }

        protected IntArraySerializer(IntArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new IntArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, int[] value) {
            return value == null || value.length == 0;
        }

        @Override
        public boolean hasSingleElement(int[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(int[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
                this.serializeContents(value, jgen, provider);
                return;
            }
            jgen.writeStartArray(len);
            this.serializeContents(value, jgen, provider);
            jgen.writeEndArray();
        }

        @Override
        public void serializeContents(int[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.INTEGER);
            }
        }
    }

    @JacksonStdImpl
    public static class CharArraySerializer
    extends StdSerializer<char[]> {
        public CharArraySerializer() {
            super(char[].class);
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, char[] value) {
            return value == null || value.length == 0;
        }

        @Override
        public void serialize(char[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (provider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                jgen.writeStartArray(value.length);
                this._writeArrayContents(jgen, value);
                jgen.writeEndArray();
            } else {
                jgen.writeString(value, 0, value.length);
            }
        }

        @Override
        public void serializeWithType(char[] value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
            if (provider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                typeSer.writeTypePrefixForArray(value, jgen);
                this._writeArrayContents(jgen, value);
                typeSer.writeTypeSuffixForArray(value, jgen);
            } else {
                typeSer.writeTypePrefixForScalar(value, jgen);
                jgen.writeString(value, 0, value.length);
                typeSer.writeTypeSuffixForScalar(value, jgen);
            }
        }

        private final void _writeArrayContents(JsonGenerator jgen, char[] value) throws IOException, JsonGenerationException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeString(value, i, 1);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            ObjectNode itemSchema = this.createSchemaNode("string");
            itemSchema.put("type", "string");
            return o.set("items", itemSchema);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.STRING);
            }
        }
    }

    @JacksonStdImpl
    public static class ShortArraySerializer
    extends TypedPrimitiveArraySerializer<short[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Short.TYPE);

        public ShortArraySerializer() {
            super(short[].class);
        }

        public ShortArraySerializer(ShortArraySerializer src, BeanProperty prop, TypeSerializer vts, Boolean unwrapSingle) {
            super(src, prop, vts, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new ShortArraySerializer(this, prop, this._valueTypeSerializer, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new ShortArraySerializer(this, this._property, vts, this._unwrapSingle);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, short[] value) {
            return value == null || value.length == 0;
        }

        @Override
        public boolean hasSingleElement(short[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(short[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
                this.serializeContents(value, jgen, provider);
                return;
            }
            jgen.writeStartArray(len);
            this.serializeContents(value, jgen, provider);
            jgen.writeEndArray();
        }

        @Override
        public void serializeContents(short[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (this._valueTypeSerializer != null) {
                int len = value.length;
                for (int i = 0; i < len; ++i) {
                    this._valueTypeSerializer.writeTypePrefixForScalar(null, jgen, Short.TYPE);
                    jgen.writeNumber(value[i]);
                    this._valueTypeSerializer.writeTypeSuffixForScalar(null, jgen);
                }
                return;
            }
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber((int)value[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            return o.set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.INTEGER);
            }
        }
    }

    @Deprecated
    @JacksonStdImpl
    public static class ByteArraySerializer
    extends com.amazonaws.thirdparty.jackson.databind.ser.std.ByteArraySerializer {
    }

    @JacksonStdImpl
    public static class BooleanArraySerializer
    extends ArraySerializerBase<boolean[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Boolean.class);

        public BooleanArraySerializer() {
            super(boolean[].class);
        }

        protected BooleanArraySerializer(BooleanArraySerializer src, BeanProperty prop, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
            return new BooleanArraySerializer(this, prop, unwrapSingle);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, boolean[] value) {
            return value == null || value.length == 0;
        }

        @Override
        public boolean hasSingleElement(boolean[] value) {
            return value.length == 1;
        }

        @Override
        public final void serialize(boolean[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            int len = value.length;
            if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
                this.serializeContents(value, jgen, provider);
                return;
            }
            jgen.writeStartArray(len);
            this.serializeContents(value, jgen, provider);
            jgen.writeEndArray();
        }

        @Override
        public void serializeContents(boolean[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeBoolean(value[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.set("items", this.createSchemaNode("boolean"));
            return o;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.BOOLEAN);
            }
        }
    }

    protected static abstract class TypedPrimitiveArraySerializer<T>
    extends ArraySerializerBase<T> {
        protected final TypeSerializer _valueTypeSerializer;

        protected TypedPrimitiveArraySerializer(Class<T> cls) {
            super(cls);
            this._valueTypeSerializer = null;
        }

        protected TypedPrimitiveArraySerializer(TypedPrimitiveArraySerializer<T> src, BeanProperty prop, TypeSerializer vts, Boolean unwrapSingle) {
            super(src, prop, unwrapSingle);
            this._valueTypeSerializer = vts;
        }
    }
}

