/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ModifyDBClusterSnapshotAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyDBClusterSnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifyDBClusterSnapshotAttributeRequest>, ModifyDBClusterSnapshotAttributeRequest> {
    @Override
    public Request<ModifyDBClusterSnapshotAttributeRequest> marshall(ModifyDBClusterSnapshotAttributeRequest modifyDBClusterSnapshotAttributeRequest) {
        SdkInternalList valuesToRemoveList;
        SdkInternalList valuesToAddList;
        if (modifyDBClusterSnapshotAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyDBClusterSnapshotAttributeRequest> request = new DefaultRequest<ModifyDBClusterSnapshotAttributeRequest>(modifyDBClusterSnapshotAttributeRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBClusterSnapshotAttribute");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBClusterSnapshotAttributeRequest.getDBClusterSnapshotIdentifier() != null) {
            request.addParameter("DBClusterSnapshotIdentifier", StringUtils.fromString(modifyDBClusterSnapshotAttributeRequest.getDBClusterSnapshotIdentifier()));
        }
        if (modifyDBClusterSnapshotAttributeRequest.getAttributeName() != null) {
            request.addParameter("AttributeName", StringUtils.fromString(modifyDBClusterSnapshotAttributeRequest.getAttributeName()));
        }
        if (!(valuesToAddList = (SdkInternalList)modifyDBClusterSnapshotAttributeRequest.getValuesToAdd()).isEmpty() || !valuesToAddList.isAutoConstruct()) {
            int valuesToAddListIndex = 1;
            for (String valuesToAddListValue : valuesToAddList) {
                if (valuesToAddListValue != null) {
                    request.addParameter("ValuesToAdd.AttributeValue." + valuesToAddListIndex, StringUtils.fromString(valuesToAddListValue));
                }
                ++valuesToAddListIndex;
            }
        }
        if (!(valuesToRemoveList = (SdkInternalList)modifyDBClusterSnapshotAttributeRequest.getValuesToRemove()).isEmpty() || !valuesToRemoveList.isAutoConstruct()) {
            int valuesToRemoveListIndex = 1;
            for (String valuesToRemoveListValue : valuesToRemoveList) {
                if (valuesToRemoveListValue != null) {
                    request.addParameter("ValuesToRemove.AttributeValue." + valuesToRemoveListIndex, StringUtils.fromString(valuesToRemoveListValue));
                }
                ++valuesToRemoveListIndex;
            }
        }
        return request;
    }
}

