/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.EngineDefaults;
import com.amazonaws.services.rds.model.Parameter;
import com.amazonaws.services.rds.model.transform.ParameterStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class EngineDefaultsStaxUnmarshaller
implements Unmarshaller<EngineDefaults, StaxUnmarshallerContext> {
    private static EngineDefaultsStaxUnmarshaller instance;

    @Override
    public EngineDefaults unmarshall(StaxUnmarshallerContext context) throws Exception {
        EngineDefaults engineDefaults = new EngineDefaults();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return engineDefaults;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DBParameterGroupFamily", targetDepth)) {
                    engineDefaults.setDBParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Marker", targetDepth)) {
                    engineDefaults.setMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    engineDefaults.withParameters(new ArrayList<Parameter>());
                    continue;
                }
                if (!context.testExpression("Parameters/Parameter", targetDepth)) continue;
                engineDefaults.withParameters(ParameterStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return engineDefaults;
    }

    public static EngineDefaultsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EngineDefaultsStaxUnmarshaller();
        }
        return instance;
    }
}

