/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.CRType;
import com.amazonaws.services.batch.model.transform.ComputeResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComputeResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private Integer minvCpus;
    private Integer maxvCpus;
    private Integer desiredvCpus;
    private List<String> instanceTypes;
    private List<String> subnets;
    private List<String> securityGroupIds;
    private String ec2KeyPair;
    private String instanceRole;
    private Map<String, String> tags;
    private Integer bidPercentage;
    private String spotIamFleetRole;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ComputeResource withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(CRType type) {
        this.type = type.toString();
    }

    public ComputeResource withType(CRType type) {
        this.setType(type);
        return this;
    }

    public void setMinvCpus(Integer minvCpus) {
        this.minvCpus = minvCpus;
    }

    public Integer getMinvCpus() {
        return this.minvCpus;
    }

    public ComputeResource withMinvCpus(Integer minvCpus) {
        this.setMinvCpus(minvCpus);
        return this;
    }

    public void setMaxvCpus(Integer maxvCpus) {
        this.maxvCpus = maxvCpus;
    }

    public Integer getMaxvCpus() {
        return this.maxvCpus;
    }

    public ComputeResource withMaxvCpus(Integer maxvCpus) {
        this.setMaxvCpus(maxvCpus);
        return this;
    }

    public void setDesiredvCpus(Integer desiredvCpus) {
        this.desiredvCpus = desiredvCpus;
    }

    public Integer getDesiredvCpus() {
        return this.desiredvCpus;
    }

    public ComputeResource withDesiredvCpus(Integer desiredvCpus) {
        this.setDesiredvCpus(desiredvCpus);
        return this;
    }

    public List<String> getInstanceTypes() {
        return this.instanceTypes;
    }

    public void setInstanceTypes(Collection<String> instanceTypes) {
        if (instanceTypes == null) {
            this.instanceTypes = null;
            return;
        }
        this.instanceTypes = new ArrayList<String>(instanceTypes);
    }

    public ComputeResource withInstanceTypes(String ... instanceTypes) {
        if (this.instanceTypes == null) {
            this.setInstanceTypes(new ArrayList<String>(instanceTypes.length));
        }
        for (String ele : instanceTypes) {
            this.instanceTypes.add(ele);
        }
        return this;
    }

    public ComputeResource withInstanceTypes(Collection<String> instanceTypes) {
        this.setInstanceTypes(instanceTypes);
        return this;
    }

    public List<String> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        this.subnets = new ArrayList<String>(subnets);
    }

    public ComputeResource withSubnets(String ... subnets) {
        if (this.subnets == null) {
            this.setSubnets(new ArrayList<String>(subnets.length));
        }
        for (String ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    public ComputeResource withSubnets(Collection<String> subnets) {
        this.setSubnets(subnets);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new ArrayList<String>(securityGroupIds);
    }

    public ComputeResource withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public ComputeResource withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public void setEc2KeyPair(String ec2KeyPair) {
        this.ec2KeyPair = ec2KeyPair;
    }

    public String getEc2KeyPair() {
        return this.ec2KeyPair;
    }

    public ComputeResource withEc2KeyPair(String ec2KeyPair) {
        this.setEc2KeyPair(ec2KeyPair);
        return this;
    }

    public void setInstanceRole(String instanceRole) {
        this.instanceRole = instanceRole;
    }

    public String getInstanceRole() {
        return this.instanceRole;
    }

    public ComputeResource withInstanceRole(String instanceRole) {
        this.setInstanceRole(instanceRole);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ComputeResource withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public ComputeResource addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public ComputeResource clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setBidPercentage(Integer bidPercentage) {
        this.bidPercentage = bidPercentage;
    }

    public Integer getBidPercentage() {
        return this.bidPercentage;
    }

    public ComputeResource withBidPercentage(Integer bidPercentage) {
        this.setBidPercentage(bidPercentage);
        return this;
    }

    public void setSpotIamFleetRole(String spotIamFleetRole) {
        this.spotIamFleetRole = spotIamFleetRole;
    }

    public String getSpotIamFleetRole() {
        return this.spotIamFleetRole;
    }

    public ComputeResource withSpotIamFleetRole(String spotIamFleetRole) {
        this.setSpotIamFleetRole(spotIamFleetRole);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getMinvCpus() != null) {
            sb.append("MinvCpus: ").append(this.getMinvCpus()).append(",");
        }
        if (this.getMaxvCpus() != null) {
            sb.append("MaxvCpus: ").append(this.getMaxvCpus()).append(",");
        }
        if (this.getDesiredvCpus() != null) {
            sb.append("DesiredvCpus: ").append(this.getDesiredvCpus()).append(",");
        }
        if (this.getInstanceTypes() != null) {
            sb.append("InstanceTypes: ").append(this.getInstanceTypes()).append(",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: ").append(this.getSubnets()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getEc2KeyPair() != null) {
            sb.append("Ec2KeyPair: ").append(this.getEc2KeyPair()).append(",");
        }
        if (this.getInstanceRole() != null) {
            sb.append("InstanceRole: ").append(this.getInstanceRole()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getBidPercentage() != null) {
            sb.append("BidPercentage: ").append(this.getBidPercentage()).append(",");
        }
        if (this.getSpotIamFleetRole() != null) {
            sb.append("SpotIamFleetRole: ").append(this.getSpotIamFleetRole());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeResource)) {
            return false;
        }
        ComputeResource other = (ComputeResource)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getMinvCpus() == null ^ this.getMinvCpus() == null) {
            return false;
        }
        if (other.getMinvCpus() != null && !other.getMinvCpus().equals(this.getMinvCpus())) {
            return false;
        }
        if (other.getMaxvCpus() == null ^ this.getMaxvCpus() == null) {
            return false;
        }
        if (other.getMaxvCpus() != null && !other.getMaxvCpus().equals(this.getMaxvCpus())) {
            return false;
        }
        if (other.getDesiredvCpus() == null ^ this.getDesiredvCpus() == null) {
            return false;
        }
        if (other.getDesiredvCpus() != null && !other.getDesiredvCpus().equals(this.getDesiredvCpus())) {
            return false;
        }
        if (other.getInstanceTypes() == null ^ this.getInstanceTypes() == null) {
            return false;
        }
        if (other.getInstanceTypes() != null && !other.getInstanceTypes().equals(this.getInstanceTypes())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        if (other.getSubnets() != null && !other.getSubnets().equals(this.getSubnets())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getEc2KeyPair() == null ^ this.getEc2KeyPair() == null) {
            return false;
        }
        if (other.getEc2KeyPair() != null && !other.getEc2KeyPair().equals(this.getEc2KeyPair())) {
            return false;
        }
        if (other.getInstanceRole() == null ^ this.getInstanceRole() == null) {
            return false;
        }
        if (other.getInstanceRole() != null && !other.getInstanceRole().equals(this.getInstanceRole())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getBidPercentage() == null ^ this.getBidPercentage() == null) {
            return false;
        }
        if (other.getBidPercentage() != null && !other.getBidPercentage().equals(this.getBidPercentage())) {
            return false;
        }
        if (other.getSpotIamFleetRole() == null ^ this.getSpotIamFleetRole() == null) {
            return false;
        }
        return other.getSpotIamFleetRole() == null || other.getSpotIamFleetRole().equals(this.getSpotIamFleetRole());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getMinvCpus() == null ? 0 : this.getMinvCpus().hashCode());
        hashCode = 31 * hashCode + (this.getMaxvCpus() == null ? 0 : this.getMaxvCpus().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredvCpus() == null ? 0 : this.getDesiredvCpus().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTypes() == null ? 0 : this.getInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getEc2KeyPair() == null ? 0 : this.getEc2KeyPair().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceRole() == null ? 0 : this.getInstanceRole().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getBidPercentage() == null ? 0 : this.getBidPercentage().hashCode());
        hashCode = 31 * hashCode + (this.getSpotIamFleetRole() == null ? 0 : this.getSpotIamFleetRole().hashCode());
        return hashCode;
    }

    public ComputeResource clone() {
        try {
            return (ComputeResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

