/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.budgets.model.BudgetType;
import com.amazonaws.services.budgets.model.CalculatedSpend;
import com.amazonaws.services.budgets.model.CostTypes;
import com.amazonaws.services.budgets.model.Spend;
import com.amazonaws.services.budgets.model.TimePeriod;
import com.amazonaws.services.budgets.model.TimeUnit;
import com.amazonaws.services.budgets.model.transform.BudgetMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Budget
implements Serializable,
Cloneable,
StructuredPojo {
    private String budgetName;
    private Spend budgetLimit;
    private Map<String, List<String>> costFilters;
    private CostTypes costTypes;
    private String timeUnit;
    private TimePeriod timePeriod;
    private CalculatedSpend calculatedSpend;
    private String budgetType;

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }

    public String getBudgetName() {
        return this.budgetName;
    }

    public Budget withBudgetName(String budgetName) {
        this.setBudgetName(budgetName);
        return this;
    }

    public void setBudgetLimit(Spend budgetLimit) {
        this.budgetLimit = budgetLimit;
    }

    public Spend getBudgetLimit() {
        return this.budgetLimit;
    }

    public Budget withBudgetLimit(Spend budgetLimit) {
        this.setBudgetLimit(budgetLimit);
        return this;
    }

    public Map<String, List<String>> getCostFilters() {
        return this.costFilters;
    }

    public void setCostFilters(Map<String, List<String>> costFilters) {
        this.costFilters = costFilters;
    }

    public Budget withCostFilters(Map<String, List<String>> costFilters) {
        this.setCostFilters(costFilters);
        return this;
    }

    public Budget addCostFiltersEntry(String key, List<String> value) {
        if (null == this.costFilters) {
            this.costFilters = new HashMap<String, List<String>>();
        }
        if (this.costFilters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.costFilters.put(key, value);
        return this;
    }

    public Budget clearCostFiltersEntries() {
        this.costFilters = null;
        return this;
    }

    public void setCostTypes(CostTypes costTypes) {
        this.costTypes = costTypes;
    }

    public CostTypes getCostTypes() {
        return this.costTypes;
    }

    public Budget withCostTypes(CostTypes costTypes) {
        this.setCostTypes(costTypes);
        return this;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    @JsonProperty(value="timeUnit")
    public String getTimeUnit() {
        return this.timeUnit;
    }

    public Budget withTimeUnit(String timeUnit) {
        this.setTimeUnit(timeUnit);
        return this;
    }

    @JsonIgnore
    public void setTimeUnit(TimeUnit timeUnit) {
        this.withTimeUnit(timeUnit);
    }

    public Budget withTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit.toString();
        return this;
    }

    public void setTimePeriod(TimePeriod timePeriod) {
        this.timePeriod = timePeriod;
    }

    public TimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public Budget withTimePeriod(TimePeriod timePeriod) {
        this.setTimePeriod(timePeriod);
        return this;
    }

    public void setCalculatedSpend(CalculatedSpend calculatedSpend) {
        this.calculatedSpend = calculatedSpend;
    }

    public CalculatedSpend getCalculatedSpend() {
        return this.calculatedSpend;
    }

    public Budget withCalculatedSpend(CalculatedSpend calculatedSpend) {
        this.setCalculatedSpend(calculatedSpend);
        return this;
    }

    public void setBudgetType(String budgetType) {
        this.budgetType = budgetType;
    }

    @JsonProperty(value="budgetType")
    public String getBudgetType() {
        return this.budgetType;
    }

    public Budget withBudgetType(String budgetType) {
        this.setBudgetType(budgetType);
        return this;
    }

    @JsonIgnore
    public void setBudgetType(BudgetType budgetType) {
        this.withBudgetType(budgetType);
    }

    public Budget withBudgetType(BudgetType budgetType) {
        this.budgetType = budgetType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBudgetName() != null) {
            sb.append("BudgetName: ").append(this.getBudgetName()).append(",");
        }
        if (this.getBudgetLimit() != null) {
            sb.append("BudgetLimit: ").append(this.getBudgetLimit()).append(",");
        }
        if (this.getCostFilters() != null) {
            sb.append("CostFilters: ").append(this.getCostFilters()).append(",");
        }
        if (this.getCostTypes() != null) {
            sb.append("CostTypes: ").append(this.getCostTypes()).append(",");
        }
        if (this.getTimeUnit() != null) {
            sb.append("TimeUnit: ").append(this.getTimeUnit()).append(",");
        }
        if (this.getTimePeriod() != null) {
            sb.append("TimePeriod: ").append(this.getTimePeriod()).append(",");
        }
        if (this.getCalculatedSpend() != null) {
            sb.append("CalculatedSpend: ").append(this.getCalculatedSpend()).append(",");
        }
        if (this.getBudgetType() != null) {
            sb.append("BudgetType: ").append(this.getBudgetType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Budget)) {
            return false;
        }
        Budget other = (Budget)obj;
        if (other.getBudgetName() == null ^ this.getBudgetName() == null) {
            return false;
        }
        if (other.getBudgetName() != null && !other.getBudgetName().equals(this.getBudgetName())) {
            return false;
        }
        if (other.getBudgetLimit() == null ^ this.getBudgetLimit() == null) {
            return false;
        }
        if (other.getBudgetLimit() != null && !other.getBudgetLimit().equals(this.getBudgetLimit())) {
            return false;
        }
        if (other.getCostFilters() == null ^ this.getCostFilters() == null) {
            return false;
        }
        if (other.getCostFilters() != null && !other.getCostFilters().equals(this.getCostFilters())) {
            return false;
        }
        if (other.getCostTypes() == null ^ this.getCostTypes() == null) {
            return false;
        }
        if (other.getCostTypes() != null && !other.getCostTypes().equals(this.getCostTypes())) {
            return false;
        }
        if (other.getTimeUnit() == null ^ this.getTimeUnit() == null) {
            return false;
        }
        if (other.getTimeUnit() != null && !other.getTimeUnit().equals(this.getTimeUnit())) {
            return false;
        }
        if (other.getTimePeriod() == null ^ this.getTimePeriod() == null) {
            return false;
        }
        if (other.getTimePeriod() != null && !other.getTimePeriod().equals(this.getTimePeriod())) {
            return false;
        }
        if (other.getCalculatedSpend() == null ^ this.getCalculatedSpend() == null) {
            return false;
        }
        if (other.getCalculatedSpend() != null && !other.getCalculatedSpend().equals(this.getCalculatedSpend())) {
            return false;
        }
        if (other.getBudgetType() == null ^ this.getBudgetType() == null) {
            return false;
        }
        return other.getBudgetType() == null || other.getBudgetType().equals(this.getBudgetType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBudgetName() == null ? 0 : this.getBudgetName().hashCode());
        hashCode = 31 * hashCode + (this.getBudgetLimit() == null ? 0 : this.getBudgetLimit().hashCode());
        hashCode = 31 * hashCode + (this.getCostFilters() == null ? 0 : this.getCostFilters().hashCode());
        hashCode = 31 * hashCode + (this.getCostTypes() == null ? 0 : this.getCostTypes().hashCode());
        hashCode = 31 * hashCode + (this.getTimeUnit() == null ? 0 : this.getTimeUnit().hashCode());
        hashCode = 31 * hashCode + (this.getTimePeriod() == null ? 0 : this.getTimePeriod().hashCode());
        hashCode = 31 * hashCode + (this.getCalculatedSpend() == null ? 0 : this.getCalculatedSpend().hashCode());
        hashCode = 31 * hashCode + (this.getBudgetType() == null ? 0 : this.getBudgetType().hashCode());
        return hashCode;
    }

    public Budget clone() {
        try {
            return (Budget)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BudgetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

