/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.budgets.AWSBudgetsAsync;
import com.amazonaws.services.budgets.AWSBudgetsAsyncClientBuilder;
import com.amazonaws.services.budgets.AWSBudgetsClient;
import com.amazonaws.services.budgets.model.CreateBudgetRequest;
import com.amazonaws.services.budgets.model.CreateBudgetResult;
import com.amazonaws.services.budgets.model.CreateNotificationRequest;
import com.amazonaws.services.budgets.model.CreateNotificationResult;
import com.amazonaws.services.budgets.model.CreateSubscriberRequest;
import com.amazonaws.services.budgets.model.CreateSubscriberResult;
import com.amazonaws.services.budgets.model.DeleteBudgetRequest;
import com.amazonaws.services.budgets.model.DeleteBudgetResult;
import com.amazonaws.services.budgets.model.DeleteNotificationRequest;
import com.amazonaws.services.budgets.model.DeleteNotificationResult;
import com.amazonaws.services.budgets.model.DeleteSubscriberRequest;
import com.amazonaws.services.budgets.model.DeleteSubscriberResult;
import com.amazonaws.services.budgets.model.DescribeBudgetRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetResult;
import com.amazonaws.services.budgets.model.DescribeBudgetsRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetsResult;
import com.amazonaws.services.budgets.model.DescribeNotificationsForBudgetRequest;
import com.amazonaws.services.budgets.model.DescribeNotificationsForBudgetResult;
import com.amazonaws.services.budgets.model.DescribeSubscribersForNotificationRequest;
import com.amazonaws.services.budgets.model.DescribeSubscribersForNotificationResult;
import com.amazonaws.services.budgets.model.UpdateBudgetRequest;
import com.amazonaws.services.budgets.model.UpdateBudgetResult;
import com.amazonaws.services.budgets.model.UpdateNotificationRequest;
import com.amazonaws.services.budgets.model.UpdateNotificationResult;
import com.amazonaws.services.budgets.model.UpdateSubscriberRequest;
import com.amazonaws.services.budgets.model.UpdateSubscriberResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSBudgetsAsyncClient
extends AWSBudgetsClient
implements AWSBudgetsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSBudgetsAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSBudgetsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSBudgetsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSBudgetsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSBudgetsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSBudgetsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSBudgetsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSBudgetsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSBudgetsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSBudgetsAsyncClientBuilder asyncBuilder() {
        return AWSBudgetsAsyncClientBuilder.standard();
    }

    AWSBudgetsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateBudgetResult> createBudgetAsync(CreateBudgetRequest request) {
        return this.createBudgetAsync(request, null);
    }

    @Override
    public Future<CreateBudgetResult> createBudgetAsync(final CreateBudgetRequest request, final AsyncHandler<CreateBudgetRequest, CreateBudgetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateBudgetResult>(){

            @Override
            public CreateBudgetResult call() throws Exception {
                CreateBudgetResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.createBudget(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNotificationResult> createNotificationAsync(CreateNotificationRequest request) {
        return this.createNotificationAsync(request, null);
    }

    @Override
    public Future<CreateNotificationResult> createNotificationAsync(final CreateNotificationRequest request, final AsyncHandler<CreateNotificationRequest, CreateNotificationResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateNotificationResult>(){

            @Override
            public CreateNotificationResult call() throws Exception {
                CreateNotificationResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.createNotification(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSubscriberResult> createSubscriberAsync(CreateSubscriberRequest request) {
        return this.createSubscriberAsync(request, null);
    }

    @Override
    public Future<CreateSubscriberResult> createSubscriberAsync(final CreateSubscriberRequest request, final AsyncHandler<CreateSubscriberRequest, CreateSubscriberResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateSubscriberResult>(){

            @Override
            public CreateSubscriberResult call() throws Exception {
                CreateSubscriberResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.createSubscriber(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBudgetResult> deleteBudgetAsync(DeleteBudgetRequest request) {
        return this.deleteBudgetAsync(request, null);
    }

    @Override
    public Future<DeleteBudgetResult> deleteBudgetAsync(final DeleteBudgetRequest request, final AsyncHandler<DeleteBudgetRequest, DeleteBudgetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteBudgetResult>(){

            @Override
            public DeleteBudgetResult call() throws Exception {
                DeleteBudgetResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.deleteBudget(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNotificationResult> deleteNotificationAsync(DeleteNotificationRequest request) {
        return this.deleteNotificationAsync(request, null);
    }

    @Override
    public Future<DeleteNotificationResult> deleteNotificationAsync(final DeleteNotificationRequest request, final AsyncHandler<DeleteNotificationRequest, DeleteNotificationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteNotificationResult>(){

            @Override
            public DeleteNotificationResult call() throws Exception {
                DeleteNotificationResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.deleteNotification(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSubscriberResult> deleteSubscriberAsync(DeleteSubscriberRequest request) {
        return this.deleteSubscriberAsync(request, null);
    }

    @Override
    public Future<DeleteSubscriberResult> deleteSubscriberAsync(final DeleteSubscriberRequest request, final AsyncHandler<DeleteSubscriberRequest, DeleteSubscriberResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteSubscriberResult>(){

            @Override
            public DeleteSubscriberResult call() throws Exception {
                DeleteSubscriberResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.deleteSubscriber(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBudgetResult> describeBudgetAsync(DescribeBudgetRequest request) {
        return this.describeBudgetAsync(request, null);
    }

    @Override
    public Future<DescribeBudgetResult> describeBudgetAsync(final DescribeBudgetRequest request, final AsyncHandler<DescribeBudgetRequest, DescribeBudgetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeBudgetResult>(){

            @Override
            public DescribeBudgetResult call() throws Exception {
                DescribeBudgetResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.describeBudget(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBudgetsResult> describeBudgetsAsync(DescribeBudgetsRequest request) {
        return this.describeBudgetsAsync(request, null);
    }

    @Override
    public Future<DescribeBudgetsResult> describeBudgetsAsync(final DescribeBudgetsRequest request, final AsyncHandler<DescribeBudgetsRequest, DescribeBudgetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeBudgetsResult>(){

            @Override
            public DescribeBudgetsResult call() throws Exception {
                DescribeBudgetsResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.describeBudgets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNotificationsForBudgetResult> describeNotificationsForBudgetAsync(DescribeNotificationsForBudgetRequest request) {
        return this.describeNotificationsForBudgetAsync(request, null);
    }

    @Override
    public Future<DescribeNotificationsForBudgetResult> describeNotificationsForBudgetAsync(final DescribeNotificationsForBudgetRequest request, final AsyncHandler<DescribeNotificationsForBudgetRequest, DescribeNotificationsForBudgetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeNotificationsForBudgetResult>(){

            @Override
            public DescribeNotificationsForBudgetResult call() throws Exception {
                DescribeNotificationsForBudgetResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.describeNotificationsForBudget(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSubscribersForNotificationResult> describeSubscribersForNotificationAsync(DescribeSubscribersForNotificationRequest request) {
        return this.describeSubscribersForNotificationAsync(request, null);
    }

    @Override
    public Future<DescribeSubscribersForNotificationResult> describeSubscribersForNotificationAsync(final DescribeSubscribersForNotificationRequest request, final AsyncHandler<DescribeSubscribersForNotificationRequest, DescribeSubscribersForNotificationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeSubscribersForNotificationResult>(){

            @Override
            public DescribeSubscribersForNotificationResult call() throws Exception {
                DescribeSubscribersForNotificationResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.describeSubscribersForNotification(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBudgetResult> updateBudgetAsync(UpdateBudgetRequest request) {
        return this.updateBudgetAsync(request, null);
    }

    @Override
    public Future<UpdateBudgetResult> updateBudgetAsync(final UpdateBudgetRequest request, final AsyncHandler<UpdateBudgetRequest, UpdateBudgetResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateBudgetResult>(){

            @Override
            public UpdateBudgetResult call() throws Exception {
                UpdateBudgetResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.updateBudget(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNotificationResult> updateNotificationAsync(UpdateNotificationRequest request) {
        return this.updateNotificationAsync(request, null);
    }

    @Override
    public Future<UpdateNotificationResult> updateNotificationAsync(final UpdateNotificationRequest request, final AsyncHandler<UpdateNotificationRequest, UpdateNotificationResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateNotificationResult>(){

            @Override
            public UpdateNotificationResult call() throws Exception {
                UpdateNotificationResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.updateNotification(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSubscriberResult> updateSubscriberAsync(UpdateSubscriberRequest request) {
        return this.updateSubscriberAsync(request, null);
    }

    @Override
    public Future<UpdateSubscriberResult> updateSubscriberAsync(final UpdateSubscriberRequest request, final AsyncHandler<UpdateSubscriberRequest, UpdateSubscriberResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateSubscriberResult>(){

            @Override
            public UpdateSubscriberResult call() throws Exception {
                UpdateSubscriberResult result;
                try {
                    result = AWSBudgetsAsyncClient.this.updateSubscriber(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

