/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.bedrockruntime.model.DocumentSource;
import java.nio.ByteBuffer;

@SdkInternalApi
public class DocumentSourceMarshaller {
    private static final MarshallingInfo<ByteBuffer> BYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bytes").build();
    private static final DocumentSourceMarshaller instance = new DocumentSourceMarshaller();

    public static DocumentSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentSource documentSource, ProtocolMarshaller protocolMarshaller) {
        if (documentSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentSource.getBytes(), BYTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

