/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockruntime.model.ContentBlock;
import com.amazonaws.services.bedrockruntime.model.ConversationRole;
import com.amazonaws.services.bedrockruntime.model.transform.MessageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Message
implements Serializable,
Cloneable,
StructuredPojo {
    private String role;
    private List<ContentBlock> content;

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public Message withRole(String role) {
        this.setRole(role);
        return this;
    }

    public Message withRole(ConversationRole role) {
        this.role = role.toString();
        return this;
    }

    public List<ContentBlock> getContent() {
        return this.content;
    }

    public void setContent(Collection<ContentBlock> content) {
        if (content == null) {
            this.content = null;
            return;
        }
        this.content = new ArrayList<ContentBlock>(content);
    }

    public Message withContent(ContentBlock ... content) {
        if (this.content == null) {
            this.setContent(new ArrayList<ContentBlock>(content.length));
        }
        for (ContentBlock ele : content) {
            this.content.add(ele);
        }
        return this;
    }

    public Message withContent(Collection<ContentBlock> content) {
        this.setContent(content);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append(this.getContent());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        return other.getContent() == null || other.getContent().equals(this.getContent());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        return hashCode;
    }

    public Message clone() {
        try {
            return (Message)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

