/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockruntime.model.Tool;
import com.amazonaws.services.bedrockruntime.model.ToolChoice;
import com.amazonaws.services.bedrockruntime.model.transform.ToolConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ToolConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Tool> tools;
    private ToolChoice toolChoice;

    public List<Tool> getTools() {
        return this.tools;
    }

    public void setTools(Collection<Tool> tools) {
        if (tools == null) {
            this.tools = null;
            return;
        }
        this.tools = new ArrayList<Tool>(tools);
    }

    public ToolConfiguration withTools(Tool ... tools) {
        if (this.tools == null) {
            this.setTools(new ArrayList<Tool>(tools.length));
        }
        for (Tool ele : tools) {
            this.tools.add(ele);
        }
        return this;
    }

    public ToolConfiguration withTools(Collection<Tool> tools) {
        this.setTools(tools);
        return this;
    }

    public void setToolChoice(ToolChoice toolChoice) {
        this.toolChoice = toolChoice;
    }

    public ToolChoice getToolChoice() {
        return this.toolChoice;
    }

    public ToolConfiguration withToolChoice(ToolChoice toolChoice) {
        this.setToolChoice(toolChoice);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTools() != null) {
            sb.append("Tools: ").append(this.getTools()).append(",");
        }
        if (this.getToolChoice() != null) {
            sb.append("ToolChoice: ").append(this.getToolChoice());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolConfiguration)) {
            return false;
        }
        ToolConfiguration other = (ToolConfiguration)obj;
        if (other.getTools() == null ^ this.getTools() == null) {
            return false;
        }
        if (other.getTools() != null && !other.getTools().equals(this.getTools())) {
            return false;
        }
        if (other.getToolChoice() == null ^ this.getToolChoice() == null) {
            return false;
        }
        return other.getToolChoice() == null || other.getToolChoice().equals(this.getToolChoice());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTools() == null ? 0 : this.getTools().hashCode());
        hashCode = 31 * hashCode + (this.getToolChoice() == null ? 0 : this.getToolChoice().hashCode());
        return hashCode;
    }

    public ToolConfiguration clone() {
        try {
            return (ToolConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ToolConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

