/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockruntime.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A custom word configured in a guardrail.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/GuardrailCustomWord"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GuardrailCustomWord implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The match for the custom word.
     * </p>
     */
    private String match;
    /**
     * <p>
     * The action for the custom word.
     * </p>
     */
    private String action;

    /**
     * <p>
     * The match for the custom word.
     * </p>
     * 
     * @param match
     *        The match for the custom word.
     */

    public void setMatch(String match) {
        this.match = match;
    }

    /**
     * <p>
     * The match for the custom word.
     * </p>
     * 
     * @return The match for the custom word.
     */

    public String getMatch() {
        return this.match;
    }

    /**
     * <p>
     * The match for the custom word.
     * </p>
     * 
     * @param match
     *        The match for the custom word.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GuardrailCustomWord withMatch(String match) {
        setMatch(match);
        return this;
    }

    /**
     * <p>
     * The action for the custom word.
     * </p>
     * 
     * @param action
     *        The action for the custom word.
     * @see GuardrailWordPolicyAction
     */

    public void setAction(String action) {
        this.action = action;
    }

    /**
     * <p>
     * The action for the custom word.
     * </p>
     * 
     * @return The action for the custom word.
     * @see GuardrailWordPolicyAction
     */

    public String getAction() {
        return this.action;
    }

    /**
     * <p>
     * The action for the custom word.
     * </p>
     * 
     * @param action
     *        The action for the custom word.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GuardrailWordPolicyAction
     */

    public GuardrailCustomWord withAction(String action) {
        setAction(action);
        return this;
    }

    /**
     * <p>
     * The action for the custom word.
     * </p>
     * 
     * @param action
     *        The action for the custom word.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GuardrailWordPolicyAction
     */

    public GuardrailCustomWord withAction(GuardrailWordPolicyAction action) {
        this.action = action.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMatch() != null)
            sb.append("Match: ").append(getMatch()).append(",");
        if (getAction() != null)
            sb.append("Action: ").append(getAction());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GuardrailCustomWord == false)
            return false;
        GuardrailCustomWord other = (GuardrailCustomWord) obj;
        if (other.getMatch() == null ^ this.getMatch() == null)
            return false;
        if (other.getMatch() != null && other.getMatch().equals(this.getMatch()) == false)
            return false;
        if (other.getAction() == null ^ this.getAction() == null)
            return false;
        if (other.getAction() != null && other.getAction().equals(this.getAction()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMatch() == null) ? 0 : getMatch().hashCode());
        hashCode = prime * hashCode + ((getAction() == null) ? 0 : getAction().hashCode());
        return hashCode;
    }

    @Override
    public GuardrailCustomWord clone() {
        try {
            return (GuardrailCustomWord) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.bedrockruntime.model.transform.GuardrailCustomWordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
