/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.bedrockagent.model.S3DataSourceConfiguration;
import java.util.List;

@SdkInternalApi
public class S3DataSourceConfigurationMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketArn").build();
    private static final MarshallingInfo<String> BUCKETOWNERACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketOwnerAccountId").build();
    private static final MarshallingInfo<List> INCLUSIONPREFIXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inclusionPrefixes").build();
    private static final S3DataSourceConfigurationMarshaller instance = new S3DataSourceConfigurationMarshaller();

    public static S3DataSourceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3DataSourceConfiguration s3DataSourceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (s3DataSourceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3DataSourceConfiguration.getBucketArn(), BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)s3DataSourceConfiguration.getBucketOwnerAccountId(), BUCKETOWNERACCOUNTID_BINDING);
            protocolMarshaller.marshall(s3DataSourceConfiguration.getInclusionPrefixes(), INCLUSIONPREFIXES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

