/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.bedrockagent.model.PromptVariant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdatePromptRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String customerEncryptionKeyArn;
    private String defaultVariant;
    private String description;
    private String name;
    private String promptIdentifier;
    private List<PromptVariant> variants;

    public void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
        this.customerEncryptionKeyArn = customerEncryptionKeyArn;
    }

    public String getCustomerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public UpdatePromptRequest withCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
        this.setCustomerEncryptionKeyArn(customerEncryptionKeyArn);
        return this;
    }

    public void setDefaultVariant(String defaultVariant) {
        this.defaultVariant = defaultVariant;
    }

    public String getDefaultVariant() {
        return this.defaultVariant;
    }

    public UpdatePromptRequest withDefaultVariant(String defaultVariant) {
        this.setDefaultVariant(defaultVariant);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdatePromptRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdatePromptRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPromptIdentifier(String promptIdentifier) {
        this.promptIdentifier = promptIdentifier;
    }

    public String getPromptIdentifier() {
        return this.promptIdentifier;
    }

    public UpdatePromptRequest withPromptIdentifier(String promptIdentifier) {
        this.setPromptIdentifier(promptIdentifier);
        return this;
    }

    public List<PromptVariant> getVariants() {
        return this.variants;
    }

    public void setVariants(Collection<PromptVariant> variants) {
        if (variants == null) {
            this.variants = null;
            return;
        }
        this.variants = new ArrayList<PromptVariant>(variants);
    }

    public UpdatePromptRequest withVariants(PromptVariant ... variants) {
        if (this.variants == null) {
            this.setVariants(new ArrayList<PromptVariant>(variants.length));
        }
        for (PromptVariant ele : variants) {
            this.variants.add(ele);
        }
        return this;
    }

    public UpdatePromptRequest withVariants(Collection<PromptVariant> variants) {
        this.setVariants(variants);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCustomerEncryptionKeyArn() != null) {
            sb.append("CustomerEncryptionKeyArn: ").append(this.getCustomerEncryptionKeyArn()).append(",");
        }
        if (this.getDefaultVariant() != null) {
            sb.append("DefaultVariant: ").append(this.getDefaultVariant()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPromptIdentifier() != null) {
            sb.append("PromptIdentifier: ").append(this.getPromptIdentifier()).append(",");
        }
        if (this.getVariants() != null) {
            sb.append("Variants: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePromptRequest)) {
            return false;
        }
        UpdatePromptRequest other = (UpdatePromptRequest)obj;
        if (other.getCustomerEncryptionKeyArn() == null ^ this.getCustomerEncryptionKeyArn() == null) {
            return false;
        }
        if (other.getCustomerEncryptionKeyArn() != null && !other.getCustomerEncryptionKeyArn().equals(this.getCustomerEncryptionKeyArn())) {
            return false;
        }
        if (other.getDefaultVariant() == null ^ this.getDefaultVariant() == null) {
            return false;
        }
        if (other.getDefaultVariant() != null && !other.getDefaultVariant().equals(this.getDefaultVariant())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPromptIdentifier() == null ^ this.getPromptIdentifier() == null) {
            return false;
        }
        if (other.getPromptIdentifier() != null && !other.getPromptIdentifier().equals(this.getPromptIdentifier())) {
            return false;
        }
        if (other.getVariants() == null ^ this.getVariants() == null) {
            return false;
        }
        return other.getVariants() == null || other.getVariants().equals(this.getVariants());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCustomerEncryptionKeyArn() == null ? 0 : this.getCustomerEncryptionKeyArn().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultVariant() == null ? 0 : this.getDefaultVariant().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPromptIdentifier() == null ? 0 : this.getPromptIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getVariants() == null ? 0 : this.getVariants().hashCode());
        return hashCode;
    }

    public UpdatePromptRequest clone() {
        return (UpdatePromptRequest)super.clone();
    }
}

