/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.bedrockagent.model.DataSourceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDataSourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DataSourceSummary> dataSourceSummaries;
    private String nextToken;

    public List<DataSourceSummary> getDataSourceSummaries() {
        return this.dataSourceSummaries;
    }

    public void setDataSourceSummaries(Collection<DataSourceSummary> dataSourceSummaries) {
        if (dataSourceSummaries == null) {
            this.dataSourceSummaries = null;
            return;
        }
        this.dataSourceSummaries = new ArrayList<DataSourceSummary>(dataSourceSummaries);
    }

    public ListDataSourcesResult withDataSourceSummaries(DataSourceSummary ... dataSourceSummaries) {
        if (this.dataSourceSummaries == null) {
            this.setDataSourceSummaries(new ArrayList<DataSourceSummary>(dataSourceSummaries.length));
        }
        for (DataSourceSummary ele : dataSourceSummaries) {
            this.dataSourceSummaries.add(ele);
        }
        return this;
    }

    public ListDataSourcesResult withDataSourceSummaries(Collection<DataSourceSummary> dataSourceSummaries) {
        this.setDataSourceSummaries(dataSourceSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDataSourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSourceSummaries() != null) {
            sb.append("DataSourceSummaries: ").append(this.getDataSourceSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourcesResult)) {
            return false;
        }
        ListDataSourcesResult other = (ListDataSourcesResult)obj;
        if (other.getDataSourceSummaries() == null ^ this.getDataSourceSummaries() == null) {
            return false;
        }
        if (other.getDataSourceSummaries() != null && !other.getDataSourceSummaries().equals(this.getDataSourceSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSourceSummaries() == null ? 0 : this.getDataSourceSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDataSourcesResult clone() {
        try {
            return (ListDataSourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

