/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.DataSourceType;
import com.amazonaws.services.bedrockagent.model.S3DataSourceConfiguration;
import com.amazonaws.services.bedrockagent.model.transform.DataSourceConfigurationMarshaller;
import java.io.Serializable;

public class DataSourceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private S3DataSourceConfiguration s3Configuration;
    private String type;

    public void setS3Configuration(S3DataSourceConfiguration s3Configuration) {
        this.s3Configuration = s3Configuration;
    }

    public S3DataSourceConfiguration getS3Configuration() {
        return this.s3Configuration;
    }

    public DataSourceConfiguration withS3Configuration(S3DataSourceConfiguration s3Configuration) {
        this.setS3Configuration(s3Configuration);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DataSourceConfiguration withType(String type) {
        this.setType(type);
        return this;
    }

    public DataSourceConfiguration withType(DataSourceType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Configuration() != null) {
            sb.append("S3Configuration: ").append(this.getS3Configuration()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration)obj;
        if (other.getS3Configuration() == null ^ this.getS3Configuration() == null) {
            return false;
        }
        if (other.getS3Configuration() != null && !other.getS3Configuration().equals(this.getS3Configuration())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Configuration() == null ? 0 : this.getS3Configuration().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public DataSourceConfiguration clone() {
        try {
            return (DataSourceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

