/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.bedrock.model.TrainingDataConfig;

@SdkInternalApi
public class TrainingDataConfigMarshaller {
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Uri").build();
    private static final TrainingDataConfigMarshaller instance = new TrainingDataConfigMarshaller();

    public static TrainingDataConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(TrainingDataConfig trainingDataConfig, ProtocolMarshaller protocolMarshaller) {
        if (trainingDataConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)trainingDataConfig.getS3Uri(), S3URI_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

